/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.rpm.index;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class RpmIndexPackageData {
    private String name;
    private String version;
    private String release;
    private String archOrSource;
    private String suffix;

    public RpmIndexPackageData(String url) {
        String filename = url.substring(url.lastIndexOf("/") + 1);
        int suffixDotIndex = filename.lastIndexOf(".");
        this.suffix = filename.substring(suffixDotIndex + 1);
        String remainder = filename.substring(0, suffixDotIndex);
        int archDotIndex = remainder.lastIndexOf(".");
        this.archOrSource = remainder.substring(archDotIndex + 1);
        this.validateArchOrSource(this.archOrSource);
        remainder = remainder.substring(0, archDotIndex);
        int releaseDashIndex = remainder.lastIndexOf("-");
        this.release = remainder.substring(releaseDashIndex + 1);
        remainder = remainder.substring(0, releaseDashIndex);
        int versionDashIndex = remainder.lastIndexOf("-");
        this.version = remainder.substring(versionDashIndex + 1);
        this.name = remainder.substring(0, versionDashIndex);
    }

    public static Set<RpmIndexPackageData> filter(Set<RpmIndexPackageData> packageSet, String versionAndRelease, String archOrSource) {
        HashSet<RpmIndexPackageData> filteredSet;
        block4: {
            RpmIndexPackageData rpmIndexPackageData;
            Iterator<RpmIndexPackageData> iterator;
            filteredSet = new HashSet<RpmIndexPackageData>();
            for (RpmIndexPackageData rpmIndexPackageData2 : packageSet) {
                String candidateVersionAndRelease = rpmIndexPackageData2.getVersion() + "-" + rpmIndexPackageData2.getRelease();
                String candidateVersionAndReleaseArchOrSource = candidateVersionAndRelease + "." + rpmIndexPackageData2.getArchOrSource();
                if (!candidateVersionAndRelease.equals(versionAndRelease) && !candidateVersionAndReleaseArchOrSource.equals(versionAndRelease) || archOrSource != null && !archOrSource.equals(rpmIndexPackageData2.getArchOrSource())) continue;
                filteredSet.add(rpmIndexPackageData2);
            }
            boolean enableFallback = false;
            if (!enableFallback) break block4;
            if (filteredSet.isEmpty()) {
                iterator = packageSet.iterator();
                while (iterator.hasNext()) {
                    rpmIndexPackageData = iterator.next();
                    String candidateVersion = rpmIndexPackageData.getVersion();
                    if (!versionAndRelease.startsWith(candidateVersion + "-") || archOrSource != null && !archOrSource.equals(rpmIndexPackageData.getArchOrSource())) continue;
                    filteredSet.add(rpmIndexPackageData);
                    break;
                }
            }
            if (filteredSet.isEmpty() && (iterator = packageSet.iterator()).hasNext()) {
                rpmIndexPackageData = iterator.next();
                filteredSet.add(rpmIndexPackageData);
            }
        }
        return filteredSet;
    }

    private void validateArchOrSource(String archOrSource) {
        if (!(archOrSource.equals("src") || archOrSource.equals("noarch") || archOrSource.equals("x86_64") || archOrSource.equals("i686") || archOrSource.equals("aarch64") || archOrSource.equals("ppc64le"))) {
            throw new IllegalStateException(archOrSource);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpmIndexPackageData that = (RpmIndexPackageData)o;
        return that.toFilename().equals(this.toFilename());
    }

    public String toFilename() {
        return this.name + "-" + this.version + "-" + this.release + "." + this.archOrSource + "." + this.suffix;
    }

    public int hashCode() {
        return Objects.hash(this.toFilename());
    }

    public String toString() {
        return "RpmIndexPackageData(name=" + this.getName() + ", version=" + this.getVersion() + ", release=" + this.getRelease() + ", archOrSource=" + this.getArchOrSource() + ", suffix=" + this.getSuffix() + ")";
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRelease() {
        return this.release;
    }

    public String getArchOrSource() {
        return this.archOrSource;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

