/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.generic.FileLocation;

public class UrlArtifactReference {
    private String url;
    private String filename;
    private String sha256Hash;
    private String ecosystem = "www";

    public UrlArtifactReference(String url) {
        this.url = url;
    }

    public UrlArtifactReference(String url, String filename, String sha256Hash, String ecosystem) {
        this.url = url;
        this.filename = filename;
        this.sha256Hash = sha256Hash;
        this.ecosystem = ecosystem;
    }

    public String deriveDownloadBaseDir() {
        try {
            URL boxedUrl = new URL(this.url);
            String host = boxedUrl.getHost();
            int port = boxedUrl.getPort();
            String base = host;
            if (port > 0) {
                base = base + "@" + port;
            }
            return base;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Provided URL malformed: " + this.url);
        }
    }

    public String deriveResourceName() {
        if (this.filename != null) {
            return this.filename;
        }
        try {
            URL boxedUrl = new URL(this.url);
            String path = boxedUrl.getPath();
            String query = boxedUrl.getQuery();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 2);
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = path.replace("/", "_");
            return path;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Provided URL malformed: " + this.url);
        }
    }

    public String deriveDownloadFileName() {
        if (this.filename != null) {
            return this.filename;
        }
        try {
            URL boxedUrl = new URL(this.url);
            String path = boxedUrl.getPath();
            String query = boxedUrl.getQuery();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 2);
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = path.replace("/", "_");
            if (StringUtils.isNotEmpty((CharSequence)query)) {
                path = path + "@" + Base64.getEncoder().encodeToString(query.getBytes());
            }
            return path;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Provided URL malformed: " + this.url);
        }
    }

    public FileLocation deriveFileLocation() {
        FileLocation fileLocation = new FileLocation();
        fileLocation.setEcosystem(this.ecosystem);
        fileLocation.setFilename(this.deriveDownloadFileName());
        fileLocation.setDispatchName(this.deriveResourceName());
        fileLocation.setResourceQualifier(this.deriveDownloadBaseDir().replace("/", "_"));
        return fileLocation;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getSha256Hash() {
        return this.sha256Hash;
    }

    public String getEcosystem() {
        return this.ecosystem;
    }
}

