/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.url;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractArtifactResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolvers;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.model.ResolvedArtifactPart;
import org.metaeffekt.artifact.resolver.url.UrlArtifactReference;
import org.metaeffekt.artifact.resolver.url.UrlDownloadAdapter;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class UrlArtifactResolver
extends AbstractArtifactResolver {
    private final UrlDownloadAdapter urlDownloadAdapter;

    public UrlArtifactResolver(DownloadLocation downloadLocation, WebAccess webAccess) {
        this.urlDownloadAdapter = new UrlDownloadAdapter(downloadLocation, webAccess);
    }

    @Override
    public ArtifactPartResolvers collectResolvers(@NonNull Artifact artifact) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        HashSet<ArtifactPartResolver> parts = new HashSet<ArtifactPartResolver>();
        this.addUrlResources(parts, artifact);
        return new ArtifactPartResolvers(parts);
    }

    private void addUrlResources(Collection<ArtifactPartResolver> parts, Artifact artifact) {
        String binaryArtifactUrl = artifact.get("Binary Artifact - URL");
        String sourceArtifactUrl = artifact.get("Source Artifact - URL");
        String sourceArchiveUrl = artifact.get("Source Archive - URL");
        String descriptorUrl = artifact.get("Descriptor - URL");
        this.addPartResolvers(parts, artifact, ArtifactPartType.BINARY_ARTIFACT, binaryArtifactUrl);
        this.addPartResolvers(parts, artifact, ArtifactPartType.SOURCE_ARTIFACT, sourceArtifactUrl);
        this.addPartResolvers(parts, artifact, ArtifactPartType.SOURCE_ARCHIVE, sourceArchiveUrl);
        this.addPartResolvers(parts, artifact, ArtifactPartType.DESCRIPTOR, descriptorUrl);
    }

    private void addPartResolvers(Collection<ArtifactPartResolver> parts, Artifact artifact, ArtifactPartType artifactPartType, String partUrl) {
        if (StringUtils.isNotEmpty((CharSequence)partUrl)) {
            UrlArtifactReference urlArtifactReference = new UrlArtifactReference(partUrl);
            parts.add(new ArtifactPartResolver(artifact, artifactPartType, () -> this.urlDownloadAdapter.resolve(urlArtifactReference), this::enrichArtifact));
        }
    }

    private Artifact enrichArtifact(ResolvedArtifactPart arp) {
        Artifact enrichedArtifact = new Artifact(arp.getOriginalArtifact());
        File resolvedFile = arp.getResolvedFile();
        if (resolvedFile != null) {
            String absolutePath = resolvedFile.getAbsolutePath();
            String partAttribute = arp.getArtifactPartType().modulateAttributeInContext("Path");
            enrichedArtifact.set(partAttribute, absolutePath);
        }
        return enrichedArtifact;
    }
}

