/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.alpine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.metaeffekt.artifact.resolver.ArtifactResolverConfig;
import org.metaeffekt.artifact.resolver.MarkerFileStatus;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.alpine.AlpineEnvironment;
import org.metaeffekt.artifact.resolver.alpine.AlpineEnvironmentParameters;
import org.metaeffekt.artifact.resolver.alpine.AlpinePackageReference;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractDownloadingAdapter;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.artifact.resolver.manager.DownloadEnvironmentManager;
import org.metaeffekt.artifact.resolver.manager.execenv.exception.EnvironmentInitializationFailure;
import org.metaeffekt.artifact.resolver.manager.execenv.exception.EnvironmentOperationFailure;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.model.ResolvedArtifactPart;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlpineDownloaderAdapter
extends AbstractDownloadingAdapter {
    private static final Logger log = LoggerFactory.getLogger(AlpineDownloaderAdapter.class);
    private final DownloadEnvironmentManager environmentManager;
    private final ArtifactResolverConfig resolverConfig;

    public AlpineDownloaderAdapter(@NonNull DownloadLocation downloadLocation, @NonNull WebAccess webAccess, @NonNull DownloadEnvironmentManager environmentManager, @NonNull ArtifactResolverConfig resolverConfig) {
        super(downloadLocation, webAccess);
        if (downloadLocation == null) {
            throw new NullPointerException("downloadLocation is marked non-null but is null");
        }
        if (webAccess == null) {
            throw new NullPointerException("webAccess is marked non-null but is null");
        }
        if (environmentManager == null) {
            throw new NullPointerException("environmentManager is marked non-null but is null");
        }
        if (resolverConfig == null) {
            throw new NullPointerException("resolverConfig is marked non-null but is null");
        }
        this.environmentManager = environmentManager;
        this.resolverConfig = resolverConfig;
    }

    public ArtifactPartResolver downloadSourceArchive(Artifact artifact, @NonNull AlpinePackageReference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        AlpineEnvironmentParameters params = new AlpineEnvironmentParameters(this.getWebAccess().getProxyConfig(), "v" + reference.getAlpineVersion());
        return new ArtifactPartResolver(artifact, ArtifactPartType.SOURCE_ARCHIVE, () -> this.resolve(params, reference), rap -> this.enrich((ResolvedArtifactPart)rap));
    }

    public ResolverResult resolve(AlpineEnvironmentParameters environmentParameters, AlpinePackageReference reference) {
        File markerParentFile;
        FileLocation fileLocation = reference.deriveFileLocation();
        File outputFile = this.deriveDownloadFile(fileLocation);
        MarkerFileStatus markerFileStatus = this.handleMarkerFile(fileLocation, reference);
        if (markerFileStatus.isIndicateSkip()) {
            return null;
        }
        if (!markerFileStatus.isInvalidMarker() && outputFile.exists()) {
            return this.resolve(outputFile, null);
        }
        log.trace("Attempting download for reference [{}].", (Object)reference);
        File markerFile = markerFileStatus.getMarkerFile();
        if (markerFile.exists() && !markerFile.delete()) {
            log.warn("Could not delete existing marker [{}]. Ignoring.", (Object)markerFile);
        }
        if (!(markerParentFile = markerFile.getParentFile()).exists() && !markerParentFile.mkdirs()) {
            log.warn("Could neither find nor create marker directory [{}]. Ignoring.", (Object)markerParentFile.getAbsolutePath());
        }
        try {
            if (!markerFile.createNewFile()) {
                log.warn("Could not create new marker [{}] for reference [{}]. Ignoring.", (Object)markerFile, (Object)reference);
            }
        }
        catch (IOException e) {
            log.warn("Could not create marker [{}] for reference [{}]. Ignoring.", (Object)markerFile, (Object)reference);
        }
        String errorMessage = null;
        try {
            AlpineEnvironment execEnv;
            try {
                execEnv = this.environmentManager.getEnvironment(environmentParameters);
            }
            catch (EnvironmentInitializationFailure e) {
                throw new IllegalStateException("Could not get working environment.", e);
            }
            if (!(execEnv instanceof AlpineEnvironment)) {
                log.error("Environment lookup for alpine returned object [{}] instead of an alpine env.", (Object)execEnv.getClass().getName());
                return null;
            }
            execEnv.getSourceArchive(reference, outputFile.toPath(), this.resolverConfig);
            AlpineDownloaderAdapter.writeMarkerFile(reference, markerFile, outputFile);
        }
        catch (EnvironmentOperationFailure e) {
            errorMessage = "Could not load package source archive.";
            log.error("Operation on package [{}] failed.", (Object)reference, (Object)e);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return this.resolve(outputFile, errorMessage);
    }

    private static void writeMarkerFile(AlpinePackageReference reference, File markerFile, File outputFile) {
        try {
            Files.write(markerFile.toPath(), outputFile.getAbsolutePath().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            log.warn("Could not write to marker [{}] for ref [{}].", (Object)markerFile, (Object)reference);
        }
    }

    private Artifact enrich(ResolvedArtifactPart resolvedArtifactPart) {
        Artifact enrichedArtifact = new Artifact(resolvedArtifactPart.getOriginalArtifact());
        File resolvedFile = resolvedArtifactPart.getResolvedFile();
        if (resolvedFile != null) {
            enrichedArtifact.set(ArtifactPartType.SOURCE_ARCHIVE.modulatePathAttribute(), resolvedFile.getAbsolutePath());
        }
        return enrichedArtifact;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MarkerFileStatus handleMarkerFile(FileLocation fileLocation, AlpinePackageReference reference) {
        File markerFile = this.deriveMarkerFile(fileLocation, reference.getPkgname() + "-" + reference.getPkgver() + "-" + reference.getPkgrel());
        if (!markerFile.exists()) return new MarkerFileStatus(markerFile, null, false, false);
        log.trace("Marker file for [{}] exists.", (Object)reference);
        try {
            long markerSize = Files.size(markerFile.toPath());
            if (markerSize <= 0L) {
                return new MarkerFileStatus(markerFile, null, false, true);
            }
        }
        catch (IOException e) {
            log.warn("Error getting size of marker file [{}].", (Object)markerFile);
            return new MarkerFileStatus(markerFile, null, false, true);
        }
        try (InputStream inputStream = Files.newInputStream(markerFile.toPath(), new OpenOption[0]);){
            String pathFromMarker = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            File referencedFile = new File(pathFromMarker);
            if (referencedFile.exists()) {
                if (!Files.isRegularFile(referencedFile.toPath(), new LinkOption[0]) || Files.size(referencedFile.toPath()) <= 0L) {
                    log.warn("Previous referenced file [{}] by marker [{}] for package [{}] failed the sanity checks.", new Object[]{referencedFile, markerFile, reference});
                    MarkerFileStatus markerFileStatus = new MarkerFileStatus(markerFile, null, false, true);
                    return markerFileStatus;
                }
                if (referencedFile.exists()) {
                    MarkerFileStatus markerFileStatus = new MarkerFileStatus(markerFile, referencedFile, false, false);
                    return markerFileStatus;
                }
            }
        }
        catch (IOException e) {
            log.error("Unable to read output path from marker file [{}].", (Object)markerFile);
            return new MarkerFileStatus(markerFile, null, false, true);
        }
        if (!this.hasRecentFailedDownloadAttempt(markerFile)) return new MarkerFileStatus(markerFile, null, false, false);
        log.info("Skipping failed download [{}]. Recent attempt failed for package: [{}].", (Object)reference, (Object)reference);
        return new MarkerFileStatus(markerFile, null, true, false);
    }
}

