/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.alpine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlpineUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AlpineUtils.class);

    public static void parseAbuildIndexLine(Map<String, List<String>> mutablePathToNameVer, String line) {
        if (StringUtils.isBlank((String)line)) {
            return;
        }
        String[] lineSplit = line.split(" ");
        String path = lineSplit[0];
        if (lineSplit.length < 2) {
            return;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (String rawName : Arrays.copyOfRange(lineSplit, 1, lineSplit.length)) {
            if (StringUtils.isBlank((String)rawName)) continue;
            Object[] nameSplit = rawName.split("-");
            if (nameSplit.length <= 2) {
                LOG.warn("raw pkgname [{}] couldn't be parsed: not in name-(name-)-ver-rel.apk format.", (Object)rawName);
                continue;
            }
            String name = StringUtils.join((Object[])nameSplit, (String)"-", (int)0, (int)(nameSplit.length - 1));
            names.add(name);
        }
        mutablePathToNameVer.put(path, new ArrayList(names));
    }
}

