/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.alpine.bodge;

import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.metaeffekt.artifact.resolver.alpine.AlpinePackageReference;
import org.metaeffekt.artifact.resolver.alpine.bodge.StringAction;
import org.metaeffekt.artifact.resolver.alpine.bodge.StringPiece;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringPieceAssembler {
    private static final Logger log = LoggerFactory.getLogger(StringPieceAssembler.class);

    protected static String getRefValue(@NonNull AlpinePackageReference packageRef, @NonNull StringPiece.RefValue refValue) {
        if (packageRef == null) {
            throw new NullPointerException("packageRef is marked non-null but is null");
        }
        if (refValue == null) {
            throw new NullPointerException("refValue is marked non-null but is null");
        }
        switch (refValue) {
            case PKGREL: {
                return packageRef.getPkgrel();
            }
            case PKGVER: {
                return packageRef.getPkgver();
            }
            case ALPINE_VERSION: {
                return packageRef.getAlpineVersion();
            }
        }
        throw new IllegalArgumentException("Unknown / unimplemented refValue given.");
    }

    public static String runDerivationForPiece(@NonNull StringPiece piece, @NonNull AlpinePackageReference packageRef) {
        Pattern finalMatchPattern;
        Matcher finalMatcher;
        if (piece == null) {
            throw new NullPointerException("piece is marked non-null but is null");
        }
        if (packageRef == null) {
            throw new NullPointerException("packageRef is marked non-null but is null");
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(piece.getLiteral());
        if (piece.getFromValue() == null) {
            return urlBuilder.toString();
        }
        String inProcessing = StringPieceAssembler.getRefValue(packageRef, piece.getFromValue());
        if (piece.getActions() != null) {
            block3: for (StringAction action : piece.getActions()) {
                switch (action.getActionType()) {
                    case PLAIN_REPLACEALL: {
                        Objects.requireNonNull(action.getFrom(), "String piece action " + (Object)((Object)action.getActionType()) + " requires non-null to and from.");
                        Objects.requireNonNull(action.getTo(), "String piece action " + (Object)((Object)action.getActionType()) + " requires non-null to and from.");
                        inProcessing = inProcessing.replaceAll(Pattern.quote(action.getFrom()), action.getTo());
                        continue block3;
                    }
                }
                log.error("Unsupported action [{}].", (Object)action.getActionType());
                throw new IllegalArgumentException("Action not supported by this version of StringPieceAssembler.");
            }
        }
        if ((finalMatcher = (finalMatchPattern = Pattern.compile(piece.getFinallyMatch())).matcher(inProcessing)).find()) {
            urlBuilder.append(finalMatcher.group());
        } else {
            log.warn("URL creation on package ref [{}] with urlPiece [{}] failed matching [{}] with pattern [{}].", new Object[]{packageRef, piece, inProcessing, piece.getFinallyMatch()});
        }
        return urlBuilder.toString();
    }

    public static String createString(List<StringPiece> pieces, AlpinePackageReference packageRef) {
        StringBuilder urlBuilder = new StringBuilder();
        for (StringPiece piece : pieces) {
            urlBuilder.append(StringPieceAssembler.runDerivationForPiece(piece, packageRef));
        }
        return urlBuilder.toString();
    }
}

