/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.cargo;

import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.url.UrlArtifactReference;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class CargoArtifactReference {
    private String name;
    private String version;
    private String sha256Hash;
    private String sourceId;

    public CargoArtifactReference(Artifact artifact) {
        String id = artifact.getId();
        String cargoSourceId = artifact.get("Cargo Source Id");
        if (id != null && cargoSourceId != null) {
            this.version = artifact.getVersion();
            int versionIndex = id.lastIndexOf("-" + this.version);
            this.name = id.substring(0, versionIndex == -1 ? id.length() - 1 : versionIndex);
            this.sha256Hash = artifact.get(ArtifactPartType.SOURCE_ARTIFACT.name() + "-" + Artifact.Attribute.HASH_SHA256);
            this.sourceId = cargoSourceId;
        }
    }

    public UrlArtifactReference deriveSourceUrlReference() {
        if (this.sourceId == null || this.sourceId.equals("registry+https://github.com/rust-lang/crates.io-index")) {
            return new UrlArtifactReference(String.format("https://crates.io/api/v1/crates/%s/%s/download", this.name, this.version), this.name + "-" + this.version + "-crate.tar.gz", this.sha256Hash, "cargo");
        }
        return null;
    }

    public boolean isValid() {
        return this.sourceId != null;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSha256Hash() {
        return this.sha256Hash;
    }

    public String getSourceId() {
        return this.sourceId;
    }
}

