/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.cargo;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import lombok.NonNull;
import org.metaeffekt.artifact.resolver.cargo.CargoArtifactReference;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractArtifactResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolvers;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.model.ResolvedArtifactPart;
import org.metaeffekt.artifact.resolver.url.UrlArtifactReference;
import org.metaeffekt.artifact.resolver.url.UrlDownloadAdapter;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class CargoArtifactResolver
extends AbstractArtifactResolver {
    private final UrlDownloadAdapter urlDownloadAdapter;

    public CargoArtifactResolver(DownloadLocation downloadLocation, WebAccess webAccess) {
        this.urlDownloadAdapter = new UrlDownloadAdapter(downloadLocation, webAccess);
    }

    @Override
    public ArtifactPartResolvers collectResolvers(@NonNull Artifact artifact) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        HashSet<ArtifactPartResolver> parts = new HashSet<ArtifactPartResolver>();
        this.addPartResolvers(parts, artifact);
        return new ArtifactPartResolvers(parts);
    }

    private void addPartResolvers(Collection<ArtifactPartResolver> parts, Artifact artifact) {
        this.addPartResolvers(parts, artifact, ArtifactPartType.SOURCE_ARTIFACT);
    }

    private void addPartResolvers(Collection<ArtifactPartResolver> parts, Artifact artifact, ArtifactPartType artifactPartType) {
        UrlArtifactReference artifactReference;
        CargoArtifactReference cargoArtifactReference = new CargoArtifactReference(artifact);
        if (cargoArtifactReference.isValid() && (artifactReference = cargoArtifactReference.deriveSourceUrlReference()) != null) {
            parts.add(new ArtifactPartResolver(artifact, artifactPartType, () -> this.urlDownloadAdapter.resolve(artifactReference), this::enrichArtifact));
        }
    }

    private Artifact enrichArtifact(ResolvedArtifactPart arp) {
        Artifact enrichedArtifact = new Artifact(arp.getOriginalArtifact());
        File resolvedFile = arp.getResolvedFile();
        if (resolvedFile != null) {
            String absolutePath = resolvedFile.getAbsolutePath();
            String partAttribute = arp.getArtifactPartType().modulateAttributeInContext("Path");
            enrichedArtifact.set(partAttribute, absolutePath);
        }
        return enrichedArtifact;
    }
}

