/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.deb;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class ControlFileSourceReference {
    private final String name;
    private final int size;
    private final Map<String, String> checksumTypeToChecksum = new HashMap<String, String>();

    public ControlFileSourceReference(@NonNull String name, int size) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.size = size;
    }

    public Collection<String> getChecksumTypes() {
        return Collections.unmodifiableCollection(this.checksumTypeToChecksum.keySet());
    }

    public String getChecksum(String type) {
        return this.checksumTypeToChecksum.get(type);
    }

    public String addChecksum(@NonNull String type, String checksum) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (checksum == null) {
            return this.checksumTypeToChecksum.remove(type.toLowerCase(Locale.ENGLISH));
        }
        return this.checksumTypeToChecksum.put(type.toLowerCase(Locale.ENGLISH), checksum);
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }
}

