/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.deb.index.packages.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.deb.index.packages.parser.PackagesEntryParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebianPackagesEntry
implements Comparable<DebianPackagesEntry> {
    private static final Logger log = LoggerFactory.getLogger(DebianPackagesEntry.class);
    private static final Pattern singleLineKeyValuePattern = Pattern.compile("^[^:]+: .+$");
    private static final Pattern spacePattern = Pattern.compile(" ");
    protected final Map<String, Field> debNameToField = this.getSupportedFieldsMap();
    private final Map<String, String> overflowKeyValueMap = new HashMap<String, String>();
    private String architecture;
    private String binary;
    private String packageName;
    private String version;
    private String source;
    private String originUrl = null;
    private static final Comparator<DebianPackagesEntry> comparator = Comparator.comparing(DebianPackagesEntry::getPackageName, ObjectUtils::compare).thenComparing(DebianPackagesEntry::getVersion, ObjectUtils::compare).thenComparing(DebianPackagesEntry::getArchitecture, ObjectUtils::compare).thenComparing(DebianPackagesEntry::getSource, ObjectUtils::compare);

    @NonNull
    public static List<DebianPackagesEntry> getValidEntries(@NonNull InputStream inputStream, String diagnostic) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        return DebianPackagesEntry.getValidEntries(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), diagnostic);
    }

    @NonNull
    public static List<DebianPackagesEntry> getValidEntries(@NonNull String fileContent, String diagnostic) {
        if (fileContent == null) {
            throw new NullPointerException("fileContent is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)fileContent)) {
            log.warn("Content of [{}] is empty. Skipping.", (Object)diagnostic);
            return Collections.emptyList();
        }
        ArrayList<DebianPackagesEntry> fileEntries = new ArrayList<DebianPackagesEntry>();
        for (String entryContent : fileContent.split("\r?\n\r?\n")) {
            try {
                DebianPackagesEntry entry = DebianPackagesEntry.parseFromSnippet(entryContent, diagnostic);
                fileEntries.add(entry);
            }
            catch (PackagesEntryParsingException e) {
                log.warn("Parsing failed for entry content [{}] of sources file [{}].", (Object)entryContent, (Object)diagnostic);
            }
        }
        return fileEntries;
    }

    @NonNull
    public static List<DebianPackagesEntry> getValidEntries(@NonNull File sourcesFile) throws IOException {
        if (sourcesFile == null) {
            throw new NullPointerException("sourcesFile is marked non-null but is null");
        }
        try (InputStream inputStream = Files.newInputStream(sourcesFile.toPath(), new OpenOption[0]);){
            List<DebianPackagesEntry> list = DebianPackagesEntry.getValidEntries(inputStream, sourcesFile.getPath());
            return list;
        }
    }

    public static DebianPackagesEntry createEntryWith(Map<String, String> keyValueMap) {
        DebianPackagesEntry sourcesEntry = new DebianPackagesEntry();
        for (Map.Entry<String, String> entry : keyValueMap.entrySet()) {
            sourcesEntry.setByKey(entry.getKey(), entry.getValue());
        }
        return sourcesEntry;
    }

    @NonNull
    public static DebianPackagesEntry parseFromSnippet(@NonNull String entryContent, String diagnostic) throws PackagesEntryParsingException {
        if (entryContent == null) {
            throw new NullPointerException("entryContent is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)entryContent)) {
            throw new PackagesEntryParsingException("Given content string was empty.");
        }
        HashMap<String, String> keyValueMap = DebianPackagesEntry.readToKeyValueMap(entryContent, diagnostic);
        return DebianPackagesEntry.createEntryWith(keyValueMap);
    }

    protected static HashMap<String, String> readToKeyValueMap(@NonNull String entryContent, String diagnostic) throws PackagesEntryParsingException {
        if (entryContent == null) {
            throw new NullPointerException("entryContent is marked non-null but is null");
        }
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        for (String line : entryContent.trim().split("\\R")) {
            String[] split;
            if (StringUtils.isBlank((CharSequence)line)) {
                log.error("Unexpected empty line while parsing content [{}]. Parser error or invalid file?", (Object)entryContent);
                continue;
            }
            if (line.startsWith(" ") || line.startsWith("\t")) continue;
            if (log.isTraceEnabled() && !singleLineKeyValuePattern.matcher(line).matches()) {
                log.trace("Line doesn't match our single line key value pattern: [{}] resolving [{}]", (Object)line, (Object)diagnostic);
            }
            if ((split = line.split(":", 2)).length != 2) {
                log.warn("Shouldn't happen: single-line key-value pair [{}] didn't split properly.", (Object)line);
                throw new PackagesEntryParsingException("Invalid Key-Value line while parsing Sources entry.");
            }
            String key = split[0].trim();
            String value = split[1].trim();
            if ("null".equals(value)) {
                log.error("value is string with value null");
            }
            if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
                String previousValue = keyValueMap.putIfAbsent(key, value);
                if (previousValue == null) continue;
                log.error("Duplicated key [{}] with line [{}] and values [{}], [{}] in entry [{}] Aborting.", new Object[]{key, line, previousValue, value, entryContent});
                throw new PackagesEntryParsingException("Duplicated key in entry.");
            }
            log.debug("Skipping key value [[{}]: [{}]] due to missing key or value.", (Object)key, (Object)value);
        }
        return keyValueMap;
    }

    protected Map<String, Field> getSupportedFieldsMap() {
        HashMap<String, Field> fieldToKey = new HashMap<String, Field>();
        this.putEntryToField(fieldToKey, "Architecture", "architecture");
        this.putEntryToField(fieldToKey, "Binary", "binary");
        this.putEntryToField(fieldToKey, "Package", "packageName");
        this.putEntryToField(fieldToKey, "Source", "source");
        this.putEntryToField(fieldToKey, "Version", "version");
        return Collections.unmodifiableMap(fieldToKey);
    }

    protected void putEntryToField(@NonNull Map<String, Field> fieldToKey, @NonNull String foreignKeyName, @NonNull String intendedFieldName) {
        if (fieldToKey == null) {
            throw new NullPointerException("fieldToKey is marked non-null but is null");
        }
        if (foreignKeyName == null) {
            throw new NullPointerException("foreignKeyName is marked non-null but is null");
        }
        if (intendedFieldName == null) {
            throw new NullPointerException("intendedFieldName is marked non-null but is null");
        }
        try {
            fieldToKey.put(foreignKeyName, this.getClass().getDeclaredField(intendedFieldName));
        }
        catch (NoSuchFieldException e) {
            log.error("No field [{}] in class [{}].", (Object)intendedFieldName, (Object)this.getClass().getSimpleName());
            throw new RuntimeException("No field of intended name (missing member field in class).", e);
        }
    }

    public Collection<String> getBinaries() {
        if (this.getBinary() == null) {
            return null;
        }
        ArrayList<String> binaries = new ArrayList<String>();
        String[] rawSplitBinary = this.getBinary().trim().split(",");
        if (rawSplitBinary.length < 1) {
            log.debug("No binaries in this [{}].", (Object)this);
        }
        for (String binary : rawSplitBinary) {
            String trimmedBinaryName = binary.trim();
            if (StringUtils.isBlank((CharSequence)trimmedBinaryName)) {
                log.debug("Blank binary name while parsing mappings in entry [{}].", (Object)this);
                return null;
            }
            binaries.add(trimmedBinaryName);
        }
        return binaries;
    }

    public String getSourcePackageName() {
        if (this.source == null) {
            return this.packageName;
        }
        int firstSpace = this.source.indexOf(32);
        return firstSpace == -1 ? this.source : this.source.substring(0, firstSpace);
    }

    public String getSourcePackageVersion() {
        if (this.source == null) {
            return this.version;
        }
        int firstSpace = this.source.indexOf(32);
        return firstSpace == -1 ? this.version : this.source.substring(firstSpace + 1).replaceAll("^\\(", "").replaceAll("\\)$", "");
    }

    private void setByKey(String key, String value) {
        Field field = this.debNameToField.get(key);
        if (field == null) {
            this.overflowKeyValueMap.put(key, value);
            return;
        }
        try {
            field.set(this, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", DebianPackagesEntry.class.getSimpleName() + "[", "]");
        for (Field field : this.debNameToField.values()) {
            try {
                joiner.add(field.getName() + "='" + field.get(this) + "'");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    @Override
    public int compareTo(@NonNull DebianPackagesEntry other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return comparator.compare(this, other);
    }

    public Map<String, Field> getDebNameToField() {
        return this.debNameToField;
    }

    public Map<String, String> getOverflowKeyValueMap() {
        return this.overflowKeyValueMap;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getBinary() {
        return this.binary;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSource() {
        return this.source;
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public void setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
    }
}

