/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.deb.index.pool;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import lombok.NonNull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.index.lucene.SimpleLuceneIndex;
import org.metaeffekt.artifact.resolver.generic.utils.GenericUtils;
import org.metaeffekt.artifact.resolver.generic.utils.MarkerUtils;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UbuntuPoolIndex {
    private static final Logger log = LoggerFactory.getLogger(UbuntuPoolIndex.class);
    private final DownloadLocation downloadLocation;
    private final WebAccess webAccess;
    private final String ubuntuPoolDirUrl;
    private final String ubuntuPoolDirUrlWithoutLastPathElement;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private SimpleLuceneIndex simpleLuceneIndex = null;
    private static final String KEY_DIRNAME = "dirname";
    private static final String KEY_FILENAMES = "filenames";
    private static final int MAX_HITS = 64;
    private static final Pattern fileExtensionPattern = Pattern.compile("\\.[a-zA-Z]{1,16}$");
    private static final Pattern newDirectoryListingPattern = Pattern.compile("^(?=(\\./.*:$|\\.:$))", 8);

    public UbuntuPoolIndex(@NonNull DownloadLocation downloadLocation, @NonNull WebAccess webAccess, @NonNull String ubuntuPoolDirUrl) {
        if (downloadLocation == null) {
            throw new NullPointerException("downloadLocation is marked non-null but is null");
        }
        if (webAccess == null) {
            throw new NullPointerException("webAccess is marked non-null but is null");
        }
        if (ubuntuPoolDirUrl == null) {
            throw new NullPointerException("ubuntuPoolDirUrl is marked non-null but is null");
        }
        this.downloadLocation = downloadLocation;
        this.webAccess = webAccess;
        this.ubuntuPoolDirUrl = ubuntuPoolDirUrl;
        this.ubuntuPoolDirUrlWithoutLastPathElement = UbuntuPoolIndex.removeLastPathElement(ubuntuPoolDirUrl);
    }

    private static String removeLastPathElement(String urlPath) {
        String noTrailingSlash = urlPath.replaceAll("/*$", "");
        int index = noTrailingSlash.lastIndexOf("/");
        if (index <= 0) {
            log.debug("Can't create ubuntu pool index from url [{}].", (Object)urlPath);
        }
        return urlPath.substring(0, index);
    }

    private void init() throws IOException {
        File downloaded;
        URL parsedUrl;
        String lsFileUrl = UbuntuPoolIndex.removeLastPathElement(this.ubuntuPoolDirUrl) + "/ls-lR.gz";
        try {
            parsedUrl = new URL(lsFileUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        File destinationFile = new File(new File(this.downloadLocation.deriveDownloadFolder("ubuntu-pool-index", parsedUrl.getHost()), "[" + parsedUrl.getHost() + "-" + UbuntuPoolIndex.urlToDownloadFilename(lsFileUrl) + "]"), UbuntuPoolIndex.urlToDownloadFilename(lsFileUrl));
        File markerFile = MarkerUtils.deriveMarkerFileFromDestination(destinationFile);
        if (markerFile.exists() && !GenericUtils.isModifiedInLast24Hours(markerFile)) {
            if (destinationFile.exists() && !destinationFile.delete()) {
                log.warn("Could not delete destination file [{}]; index may not refresh.", (Object)destinationFile);
            }
            if (!markerFile.delete()) {
                log.warn("Could not delete marker file [{}]; index may not refresh.", (Object)markerFile);
            }
        }
        if ((downloaded = MarkerUtils.attemptDownload(markerFile, destinationFile.getName() + " of class " + this.getClass().getSimpleName() + ": " + this.ubuntuPoolDirUrl, () -> GenericUtils.downloadFile(this.webAccess, lsFileUrl, destinationFile, this.getClass().getSimpleName() + ": " + this.ubuntuPoolDirUrl))) == null) {
            log.debug("Index creation for pool [{}] aborting: listing download failed.", (Object)lsFileUrl);
            return;
        }
        File luceneIndexLocation = new File(downloaded.getParentFile(), downloaded.getName() + "-lucene");
        this.simpleLuceneIndex = new SimpleLuceneIndex(luceneIndexLocation);
        this.simpleLuceneIndex.clear();
        HashMap<String, Collection> entryMap = null;
        try (InputStream inputStream = Files.newInputStream(downloaded.toPath(), new OpenOption[0]);
             GZIPInputStream decompressed = new GZIPInputStream(inputStream, 65536);
             InputStreamReader intermediateReader = new InputStreamReader((InputStream)decompressed, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(intermediateReader, 65536);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line)) continue;
                if (newDirectoryListingPattern.matcher(line = line.trim()).find()) {
                    if (entryMap != null) {
                        this.simpleLuceneIndex.addEntry(entryMap);
                    }
                    entryMap = new HashMap<String, Collection>();
                    String lsDirname = line.substring(0, line.length() - 1);
                    entryMap.put(KEY_DIRNAME, Collections.singletonList(lsDirname));
                    continue;
                }
                if (entryMap == null) {
                    log.debug("Unable to associate line with directory: line [{}].", (Object)line);
                    continue;
                }
                String[] lsOutputSplit = StringUtils.split((String)line);
                if (StringUtils.equalsIgnoreCase((CharSequence)"total", (CharSequence)lsOutputSplit[0]) && lsOutputSplit.length == 2) continue;
                String filename = lsOutputSplit[lsOutputSplit.length - 1].trim();
                if (StringUtils.isBlank((CharSequence)filename)) {
                    log.trace("Got empty filename trying to add line [{}].", (Object)line);
                    continue;
                }
                entryMap.computeIfAbsent(KEY_FILENAMES, key -> new LinkedHashSet()).add(filename);
            }
        }
        if (entryMap != null) {
            this.simpleLuceneIndex.addEntry(entryMap);
        }
        this.simpleLuceneIndex.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitialized() throws IOException {
        AtomicBoolean atomicBoolean = this.initialized;
        synchronized (atomicBoolean) {
            if (!this.initialized.get()) {
                log.debug("Initializing lazy index...");
                this.init();
                this.initialized.set(true);
            }
            if (this.simpleLuceneIndex == null) {
                throw new IOException("Index is not properly initialized: lucene index is not available.");
            }
        }
    }

    private static String urlToDownloadFilename(String url) {
        int lastDot = url.lastIndexOf(46);
        String uncleanEnding = lastDot != -1 ? url.substring(lastDot) : "";
        String clean = fileExtensionPattern.matcher(uncleanEnding).find() ? uncleanEnding : "";
        return "sha256-" + DigestUtils.sha256Hex((byte[])url.getBytes(StandardCharsets.UTF_8)) + clean;
    }

    @NonNull
    public List<String> getDirectoriesFromFilename(@NonNull String filename) throws IOException {
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.ensureInitialized();
        List<Document> foundDocuments = this.simpleLuceneIndex.lookupContains(KEY_FILENAMES, filename, 64);
        if (foundDocuments.isEmpty()) {
            log.trace("Found no documents for filename [{}] in ubuntu pool index [{}].", (Object)filename, (Object)this.ubuntuPoolDirUrl);
            return Collections.emptyList();
        }
        if (foundDocuments.size() > 1) {
            log.debug("Got multiple hits for queried filename [{}].", (Object)filename);
        }
        if (foundDocuments.size() >= 64) {
            log.debug("Max hits reached while searching ubuntu pool index [{}] for name [{}]. Might lose matches!", (Object)this.ubuntuPoolDirUrl, (Object)filename);
        }
        return foundDocuments.stream().filter(Objects::nonNull).map(doc -> doc.get(KEY_DIRNAME)).filter(dirInIndex -> dirInIndex.startsWith("./pool/")).map(dirInIndex -> this.ubuntuPoolDirUrlWithoutLastPathElement + "/" + dirInIndex.replaceFirst("^\\./", "")).collect(Collectors.toList());
    }

    public String getUbuntuPoolDirUrl() {
        return this.ubuntuPoolDirUrl;
    }
}

