/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.deb.ubuntu;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.deb.ControlFileSourceReference;
import org.metaeffekt.artifact.resolver.deb.DebArtifactReference;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractDownloadingAdapter;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.artifact.resolver.generic.utils.GenericUtils;
import org.metaeffekt.artifact.resolver.generic.utils.MarkerUtils;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UbuntuLaunchpadAdapter
extends AbstractDownloadingAdapter {
    private static final Logger log = LoggerFactory.getLogger(UbuntuLaunchpadAdapter.class);
    protected final Pattern lowerHexPattern = Pattern.compile("[0-9a-f]+");
    protected final Pattern sizePattern = Pattern.compile("[0-9]+");
    protected final Pattern controlCharacter = Pattern.compile("\\p{Cntrl}");

    public UbuntuLaunchpadAdapter(DownloadLocation downloadLocation, WebAccess webAccess) {
        super(downloadLocation, webAccess);
    }

    public List<ControlFileSourceReference> getFilesFromControlFile(@NonNull File dscFile) {
        if (dscFile == null) {
            throw new NullPointerException("dscFile is marked non-null but is null");
        }
        HashMap<String, List> typesToLines = new HashMap<String, List>();
        try {
            String currentField = null;
            boolean skipAfterSignatureStart = false;
            long lineCount = 0L;
            for (String line : Files.readAllLines(dscFile.toPath(), StandardCharsets.UTF_8)) {
                String lineContent;
                ++lineCount;
                if (StringUtils.isBlank((CharSequence)line)) continue;
                if (!line.startsWith(" ") && !line.startsWith("\t")) {
                    int colonIndex;
                    if (!line.contains(":")) {
                        if (lineCount == 1L && line.trim().equals("-----BEGIN PGP SIGNED MESSAGE-----")) {
                            log.trace("Skipping begin PGP signed message line while parsing.");
                            continue;
                        }
                        if (skipAfterSignatureStart || line.trim().contains("-----BEGIN PGP SIGNATURE-----")) {
                            skipAfterSignatureStart = !line.trim().contains("-----END PGP SIGNATURE-----");
                            continue;
                        }
                        if (currentField == null) {
                            log.warn("A line [{}] in [{}] didn't start with space or tab but didn't contain colon: [{}].", new Object[]{lineCount, dscFile, line});
                        } else {
                            log.warn("A line [{}] after [{}] in [{}] didn't start with space or tab but didn't contain colon: [{}].", new Object[]{lineCount, currentField, dscFile, line});
                        }
                    }
                    if ((colonIndex = line.indexOf(58)) <= 0) break;
                    currentField = line.substring(0, colonIndex);
                    lineContent = line.substring(colonIndex + 1);
                } else {
                    lineContent = line.substring(1);
                }
                if (currentField == null) {
                    log.warn("No field before value [{}].", (Object)line);
                    continue;
                }
                if (currentField.toLowerCase(Locale.ENGLISH).startsWith("checksums-")) {
                    String hashType = currentField.toLowerCase(Locale.ENGLISH).substring(currentField.indexOf("-") + 1).trim();
                    if (StringUtils.isNotBlank((CharSequence)lineContent.trim())) {
                        typesToLines.computeIfAbsent(hashType, key -> new ArrayList()).add(lineContent.trim());
                    }
                }
                if (!currentField.toLowerCase(Locale.ENGLISH).equals("files") || !StringUtils.isNotBlank((CharSequence)lineContent.trim())) continue;
                typesToLines.computeIfAbsent("md5", key -> new ArrayList()).add(lineContent.trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, ControlFileSourceReference> sourceReferenceMap = new HashMap<String, ControlFileSourceReference>();
        for (Map.Entry entry : typesToLines.entrySet()) {
            for (String line : (List)entry.getValue()) {
                String previousHashValue;
                int sizeInt;
                String sizeString;
                String[] splitLine = StringUtils.strip((String)line).split(" ");
                if (splitLine.length != 3) {
                    log.error("Line [{}] split (around space) into [{}] (not three) fields.", (Object)line, (Object)splitLine.length);
                    continue;
                }
                String hashValue = splitLine[0];
                if (!this.lowerHexPattern.matcher(hashValue).matches()) {
                    log.warn("Hash value [{}] from dcs [{}] does not look hexadecimal.", (Object)hashValue, (Object)dscFile);
                }
                if (!this.sizePattern.matcher(sizeString = splitLine[1]).matches()) {
                    log.warn("Size value [{}] from line [{}] of type [{}] from dcs [{}] doesn't look like an integer.", new Object[]{sizeString, line, entry.getKey(), dscFile});
                }
                try {
                    sizeInt = Integer.parseInt(sizeString);
                }
                catch (NumberFormatException e) {
                    sizeInt = -1;
                }
                String filename = splitLine[2];
                if (filename.contains("\n") || filename.contains("\r") || filename.contains(" ") || this.controlCharacter.matcher(filename).find()) {
                    log.warn("Filename value [{}] from line [{}] of type [{}] from dcs [{}] contains unusual content.", new Object[]{filename, line, entry.getKey(), dscFile});
                    return null;
                }
                ControlFileSourceReference reference = (ControlFileSourceReference)sourceReferenceMap.get(filename);
                if (reference == null) {
                    reference = new ControlFileSourceReference(filename, sizeInt);
                    sourceReferenceMap.put(filename, reference);
                }
                if ((previousHashValue = reference.addChecksum((String)entry.getKey(), hashValue)) == null) continue;
                log.warn("Oddity: Duplicate checksum of type [{}] with values [{}], [{}]. Might indicate error.", new Object[]{entry.getKey(), hashValue, previousHashValue});
            }
        }
        return new ArrayList<ControlFileSourceReference>(sourceReferenceMap.values());
    }

    protected String getLaunchpadUrl(DebArtifactReference reference, String filename) {
        StringJoiner dscUrlJoiner = new StringJoiner("/");
        dscUrlJoiner.add("https://launchpad.net/ubuntu/+archive/primary/+sourcefiles");
        dscUrlJoiner.add(reference.getName());
        dscUrlJoiner.add(reference.getVersion());
        dscUrlJoiner.add(filename);
        return dscUrlJoiner.toString();
    }

    protected File downloadDscFile(DebArtifactReference reference, String dscFilename) {
        FileLocation fileLocation = reference.deriveFileLocation(dscFilename);
        File file = this.deriveDownloadFile(fileLocation);
        File dscMarkerFile = this.deriveMarkerFile(fileLocation, "ubuntu_" + dscFilename);
        String dscUrl = this.getLaunchpadUrl(reference, dscFilename);
        return GenericUtils.downloadFile(this.getWebAccess(), dscUrl, file, dscMarkerFile, reference.toString());
    }

    protected File downloadSourceFile(DebArtifactReference reference, String sourceFilename) {
        FileLocation fileLocation = reference.deriveFileLocation(sourceFilename);
        File file = this.deriveDownloadFile(fileLocation);
        File dscMarkerFile = this.deriveMarkerFile(fileLocation, "ubuntu_" + sourceFilename);
        String fileUrl = this.getLaunchpadUrl(reference, sourceFilename);
        return GenericUtils.downloadFile(this.getWebAccess(), fileUrl, file, dscMarkerFile, reference.toString());
    }

    public static boolean sanityCheckOutputExists(@NonNull File fileToCheck, File correspondingMarker, DebArtifactReference reference) {
        if (fileToCheck == null) {
            throw new NullPointerException("fileToCheck is marked non-null but is null");
        }
        try {
            if (!fileToCheck.exists() || !Files.isRegularFile(fileToCheck.toPath(), new LinkOption[0]) || Files.size(fileToCheck.toPath()) <= 0L) {
                log.warn("Previous output file [{}] of marker [{}] for ref [{}] failed sanity checks. Using anyway. Consider removal of its marker and output.", new Object[]{fileToCheck, correspondingMarker, reference});
                return false;
            }
            return true;
        }
        catch (IOException e) {
            log.trace("IOException while sanity checking existence of file [{}].", (Object)fileToCheck);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public File repackageSourcesToZip(@NonNull DebArtifactReference reference, @NonNull String targetFilename, @NonNull List<ControlFileSourceReference> srcReferences, @NonNull HashMap<ControlFileSourceReference, File> sourceRefToFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 63[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public boolean checksumOk(@NonNull ControlFileSourceReference sourceRef, @NonNull File sourceFile, @NonNull DebArtifactReference ref) {
        if (sourceRef == null) {
            throw new NullPointerException("sourceRef is marked non-null but is null");
        }
        if (sourceFile == null) {
            throw new NullPointerException("sourceFile is marked non-null but is null");
        }
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        allMatch = true;
        if (sourceRef.getChecksumTypes().isEmpty()) {
            UbuntuLaunchpadAdapter.log.warn("No checksums to check for file [{}] of sourceRef [{}] of ref [{}].", new Object[]{sourceFile, sourceRef, ref});
        }
lbl10:
        // 15 sources

        block21: for (String checksumType : sourceRef.getChecksumTypes()) {
            try {
                inputStream = Files.newInputStream(sourceFile.toPath(), new OpenOption[0]);
                var8_9 = null;
                try {
                    var9_10 = checksumType;
                    var10_13 = -1;
                    switch (var9_10.hashCode()) {
                        case -903629273: {
                            if (!var9_10.equals("sha256")) break;
                            var10_13 = 0;
                            break;
                        }
                        case 3528965: {
                            if (!var9_10.equals("sha1")) break;
                            var10_13 = 1;
                            break;
                        }
                        case 107902: {
                            if (!var9_10.equals("md5")) break;
                            var10_13 = 2;
                        }
                    }
                    switch (var10_13) {
                        case 0: {
                            sha256Matches = DigestUtils.sha256Hex((InputStream)inputStream).toLowerCase(Locale.ENGLISH).equals(sourceRef.getChecksum(checksumType));
                            allMatch &= sha256Matches;
                            if (sha256Matches) continue block21;
                            UbuntuLaunchpadAdapter.log.warn("Sha256 checksum of [{}] does not match expected [{}].", (Object)sourceFile, (Object)sourceRef.getChecksum("sha256"));
                            ** break;
                        }
                        case 1: {
                            sha1Matches = DigestUtils.sha1Hex((InputStream)inputStream).toLowerCase(Locale.ENGLISH).equals(sourceRef.getChecksum(checksumType));
                            allMatch &= sha1Matches;
                            if (sha1Matches) continue block21;
                            UbuntuLaunchpadAdapter.log.warn("Sha1 checksum of [{}] does not match expected [{}].", (Object)sourceFile, (Object)sourceRef.getChecksum("sha1"));
                            ** break;
                        }
                        case 2: {
                            md5Matches = DigestUtils.md5Hex((InputStream)inputStream).toLowerCase(Locale.ENGLISH).equals(sourceRef.getChecksum(checksumType));
                            allMatch &= md5Matches;
                            if (md5Matches) continue block21;
                            UbuntuLaunchpadAdapter.log.warn("Md5 checksum of [{}] does not match expected [{}].", (Object)sourceFile, (Object)sourceRef.getChecksum("md5"));
                            ** break;
                        }
                        default: {
                            UbuntuLaunchpadAdapter.log.warn("Can't handle checksum type [{}] in [{}] yet.", (Object)checksumType, (Object)this.getClass().getSimpleName());
                            continue block21;
                        }
                    }
                }
                catch (Throwable var9_12) {
                    var8_9 = var9_12;
                    throw var9_12;
                }
                finally {
                    if (inputStream == null) continue;
                    if (var8_9 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable var9_11) {
                            var8_9.addSuppressed(var9_11);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException e) {
                UbuntuLaunchpadAdapter.log.warn("IOException while checking checksums for file [{}] of source ref [{}] of ref [{}] : [{}]", new Object[]{sourceFile, sourceRef, ref, ExceptionUtils.getStackTrace((Throwable)e)});
            }
        }
        if (!allMatch) {
            UbuntuLaunchpadAdapter.log.warn("Invalidating download marker for [{}] of ref [{}] due to mismatched checksums.", (Object)sourceFile.getAbsolutePath(), (Object)ref);
            MarkerUtils.invalidateMarkerFor(sourceFile, ref.toString());
        }
        return allMatch;
    }

    public ResolverResult downloadSourceArtifact(@NonNull DebArtifactReference sourcePackageRef) {
        int colonIndex;
        if (sourcePackageRef == null) {
            throw new NullPointerException("sourcePackageRef is marked non-null but is null");
        }
        if (!sourcePackageRef.isValid()) {
            return null;
        }
        if (sourcePackageRef.getNamespace() != DebArtifactReference.DebNamespace.UBUNTU) {
            log.warn("Namespace of given ref [{}] is not UBUNTU.", (Object)sourcePackageRef);
        }
        String versionWithoutEpoch = (colonIndex = sourcePackageRef.getVersion().indexOf(58)) == -1 ? sourcePackageRef.getVersion() : sourcePackageRef.getVersion().substring(colonIndex + 1);
        String dscFilename = sourcePackageRef.getName() + "_" + versionWithoutEpoch + ".dsc";
        File dscFile = this.downloadDscFile(sourcePackageRef, dscFilename);
        if (dscFile == null) {
            log.info("Failed to download dsc file for [{}].", (Object)sourcePackageRef);
            return null;
        }
        HashMap<ControlFileSourceReference, File> sourceRefToFile = new HashMap<ControlFileSourceReference, File>();
        try {
            List<ControlFileSourceReference> sourceReferences = this.getFilesFromControlFile(dscFile);
            if (sourceReferences == null) {
                log.warn("Error getting source references for [{}].", (Object)sourcePackageRef);
                return null;
            }
            if (sourceReferences.isEmpty()) {
                log.trace("List of source references empty for [{}].", (Object)sourcePackageRef);
                return null;
            }
            for (ControlFileSourceReference sourceRef : sourceReferences) {
                File sourceFile = this.downloadSourceFile(sourcePackageRef, sourceRef.getName());
                if (sourceFile == null) {
                    return null;
                }
                if (!this.checksumOk(sourceRef, sourceFile, sourcePackageRef)) {
                    return null;
                }
                try {
                    long size = Files.size(sourceFile.toPath());
                    if (sourceRef.getSize() != -1 && size != (long)sourceRef.getSize()) {
                        log.warn("File size of [{}] isn't expected [{}].", (Object)sourceFile.getAbsolutePath(), (Object)size);
                    }
                }
                catch (IOException e) {
                    log.warn("IOException while trying to check file size of [{}].", (Object)sourceFile.getAbsolutePath());
                }
                sourceRefToFile.put(sourceRef, sourceFile);
            }
            String sourceRepackageFilename = "ae-source-repackage-ubuntu-" + sourcePackageRef.getName() + "-" + sourcePackageRef.getVersion() + "-" + sourcePackageRef.getArchitecture() + ".zip";
            return this.resolve(this.repackageSourcesToZip(sourcePackageRef, sourceRepackageFilename, sourceReferences, sourceRefToFile), null);
        }
        catch (Exception e) {
            log.warn("Resolver failed for reference [{}] with: [{}].", (Object)sourcePackageRef, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return this.resolveWithError(sourcePackageRef, e);
        }
    }
}

