/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.download;

import java.io.File;
import java.io.IOException;
import org.metaeffekt.core.util.FileUtils;
import org.yaml.snakeyaml.Yaml;

public class ProxyConfig {
    private String scheme;
    private String host;
    private int port;
    private String username;
    private String password;
    private String nonProxyHosts;

    public static ProxyConfig parseFromYaml(File yamlFile) throws IOException {
        String content = FileUtils.readFileToString((File)yamlFile, (String)"UTF-8");
        return (ProxyConfig)new Yaml().loadAs(content, ProxyConfig.class);
    }

    public boolean isValid() {
        return this.host != null && this.port > 0;
    }

    public String getProxyString() {
        return String.format("%s://%s:%s/", this.getScheme(), this.getHost(), this.getPort());
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }
}

