/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.download;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retry<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Retry.class);
    private final RetrySupplier<T> supplier;
    private final List<Class<? extends Throwable>> exceptions = new ArrayList<Class<? extends Throwable>>();
    private final List<Validator<T>> validators = new ArrayList<Validator<T>>();
    private int retryCount = 0;
    private int delay = 0;
    private Consumer<Throwable> onFailure;

    public Retry(RetrySupplier<T> supplier) {
        this.supplier = supplier;
    }

    public Retry(RetrySupplierNoReturnValue supplier) {
        this.supplier = () -> {
            supplier.get();
            return null;
        };
    }

    public Retry<T> onException(Class<? extends Throwable> exceptionClass) {
        this.exceptions.add(exceptionClass);
        return this;
    }

    public Retry<T> retryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public Retry<T> withValidator(Validator<T> validator) {
        this.validators.add(validator);
        return this;
    }

    public Retry<T> onFailure(Consumer<Throwable> onFailure) {
        this.onFailure = onFailure;
        return this;
    }

    public Retry<T> withDelay(int delay) {
        this.delay = delay;
        return this;
    }

    private boolean isThrowableContained(Throwable throwable) {
        for (Class<? extends Throwable> exceptionClass : this.exceptions) {
            if (!exceptionClass.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }

    public T run() {
        Throwable caughtException = null;
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                Object result = this.supplier.get();
                if (!this.validators.isEmpty() && this.validators.stream().noneMatch(validator -> validator.isValid(result))) {
                    throw new RuntimeException("Retry validation failed on attempt [" + (i + 1) + " / " + this.retryCount + "]");
                }
                return result;
            }
            catch (Throwable throwable) {
                if (i == this.retryCount - 1) {
                    LOG.error("failed last attempt [{}] due to invalid run result: {}", (Object)this.retryCount, (Object)throwable.getMessage());
                } else {
                    LOG.warn("retrying next attempt [{} / {}] due to invalid run result: {}", new Object[]{i + 2, this.retryCount, throwable.getMessage()});
                }
                if (!this.isThrowableContained(throwable)) {
                    if (this.onFailure != null) {
                        this.onFailure.accept(throwable);
                    }
                    throw new RuntimeException(throwable);
                }
                caughtException = throwable;
                if (this.delay <= 0) continue;
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Unable to sleep", e);
                }
            }
        }
        if (this.onFailure != null) {
            this.onFailure.accept(caughtException);
        }
        if (caughtException != null) {
            throw new RuntimeException(caughtException);
        }
        throw new RuntimeException("Retry failed due to unknown reason");
    }

    @FunctionalInterface
    public static interface Validator<T> {
        public boolean isValid(T var1);
    }

    public static interface RetrySupplierNoReturnValue {
        public void get() throws Throwable;
    }

    public static interface RetrySupplier<T> {
        public T get() throws Throwable;
    }
}

