/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.download;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.metaeffekt.artifact.resolver.download.ProxyConfig;
import org.metaeffekt.core.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAccess {
    private static final Logger LOG = LoggerFactory.getLogger(WebAccess.class);
    private final HttpHost proxy;
    private final CredentialsProvider credentialsProvider;
    private final ProxyConfig proxyConfig;

    public WebAccess(ProxyConfig proxyConfig) {
        LOG.debug("Setting up proxy credentials for downloader.");
        if (proxyConfig.isValid()) {
            LOG.info("Using proxy: {}://{}:{}.", new Object[]{proxyConfig.getScheme(), proxyConfig.getHost(), proxyConfig.getPort()});
            this.proxyConfig = proxyConfig;
            this.proxy = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getScheme());
            if (!StringUtils.isBlank((CharSequence)proxyConfig.getUsername())) {
                LOG.info("Using proxy user: [{}].", (Object)proxyConfig.getUsername());
                this.credentialsProvider = new BasicCredentialsProvider();
                this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyConfig.getUsername(), proxyConfig.getPassword()));
            } else {
                this.credentialsProvider = null;
            }
        } else {
            LOG.info("No valid proxy configured. Operating without proxy.");
            this.proxyConfig = null;
            this.proxy = null;
            this.credentialsProvider = null;
        }
    }

    public RequestConfig getProxyRequestConfig() {
        if (this.proxy != null) {
            return RequestConfig.custom().setProxy(this.proxy).build();
        }
        return RequestConfig.custom().build();
    }

    public WebSession createSession() {
        return new WebSession(this);
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public static class WebSession
    implements Closeable {
        private final CloseableHttpClient httpClient;
        private final WebAccess webAccess;

        public WebSession(WebAccess webAccess) {
            this.webAccess = webAccess;
            this.httpClient = this.createHttpClient();
        }

        @Override
        public void close() throws IOException {
            this.httpClient.close();
        }

        private CloseableHttpClient createHttpClient() {
            HttpClientBuilder httpClient = HttpClients.custom();
            int timeOutInSeconds = 10;
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).setContentCompressionEnabled(false).build();
            httpClient.setDefaultRequestConfig(requestConfig);
            httpClient.disableContentCompression();
            if (this.webAccess.credentialsProvider != null) {
                httpClient.setDefaultCredentialsProvider(this.webAccess.credentialsProvider);
            }
            return httpClient.build();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NonNull
        public Optional<String> downloadToUtf8String(String uri, Consumer<HttpResponse> errorConsumer) {
            HttpGet get = new HttpGet(uri);
            get.setConfig(this.webAccess.getProxyRequestConfig());
            HttpClientContext context = new HttpClientContext();
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get, (HttpContext)context);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                        IOUtils.copyLarge((InputStream)response.getEntity().getContent(), (OutputStream)bos);
                        Optional<String> optional = Optional.of(new String(bos.toByteArray(), StandardCharsets.UTF_8));
                        return optional;
                    }
                }
                LOG.info("Cannot download URI [{}]. Site returned: {}", (Object)uri, (Object)response.getStatusLine());
                errorConsumer.accept((HttpResponse)response);
                return Optional.empty();
            }
            catch (Exception e) {
                LOG.info("Cannot download uri [{}]. Request timed out.", (Object)uri, (Object)e);
                return Optional.empty();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Optional<File> downloadFile(String uri, File file, Consumer<HttpResponse> errorConsumer) {
            HttpGet get = new HttpGet(uri);
            get.setConfig(this.webAccess.getProxyRequestConfig());
            HttpClientContext context = new HttpClientContext();
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get, (HttpContext)context);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    long downloadStartTime = System.nanoTime();
                    FileUtils.copyInputStreamToFile((InputStream)response.getEntity().getContent(), (File)file);
                    long downloadEndTime = System.nanoTime();
                    double totalTimeSeconds = (double)(downloadEndTime - downloadStartTime) / 1.0E9;
                    long fileSizeKB = Files.size(file.toPath()) / 1024L;
                    LOG.debug("Finished download stats: uri [{}] to file [{}] of size [{}]KB in [{}]s at approx [{}]KB/s.", new Object[]{uri, file, fileSizeKB, String.format("%.3f", totalTimeSeconds), String.format("%.2f", (double)fileSizeKB / totalTimeSeconds)});
                    Optional<File> optional2 = Optional.of(file);
                    return optional2;
                }
                LOG.info("Cannot download URI [{}]. Site returned: {}", (Object)uri, (Object)response.getStatusLine());
                errorConsumer.accept((HttpResponse)response);
                Optional<File> optional = Optional.empty();
                return optional;
            }
            catch (Exception e) {
                LOG.info("Cannot download uri [{}]. Request timed out.", (Object)uri, (Object)e);
                return Optional.empty();
            }
        }
    }
}

