/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.generic;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.util.HashMap;
import java.util.Map;
import org.metaeffekt.artifact.resolver.generic.IndexConfig;
import org.metaeffekt.artifact.resolver.maven.MavenArtifactReference;

public class ArtifactIndex {
    private Map<String, MavenArtifactReference> index = new HashMap<String, MavenArtifactReference>();

    public ArtifactIndex(IndexConfig purlMappingConfig) {
        this.configure(purlMappingConfig);
    }

    private void configure(IndexConfig purlMappingConfig) {
        Map<String, String> purlMapping;
        if (purlMappingConfig != null && (purlMapping = purlMappingConfig.getPurlMapping()) != null) {
            try {
                for (Map.Entry<String, String> entry : purlMapping.entrySet()) {
                    this.index.put(entry.getKey(), new MavenArtifactReference(new PackageURL(entry.getValue())));
                }
            }
            catch (MalformedPackageURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public MavenArtifactReference map(String id, String checksum) {
        return this.index.get(id);
    }
}

