/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.generic;

import org.apache.commons.lang3.StringUtils;

public class FileLocation {
    private String ecosystem;
    private String filename;
    private String dispatchName;
    private String resourceQualifier;

    public boolean isValid() {
        boolean valid = StringUtils.isNotBlank((CharSequence)this.ecosystem);
        valid |= StringUtils.isNotEmpty((CharSequence)this.filename);
        valid |= StringUtils.isNotEmpty((CharSequence)this.dispatchName);
        valid |= StringUtils.isNotEmpty((CharSequence)this.resourceQualifier);
        valid |= this.validateNoPath(this.ecosystem);
        valid |= this.validateNoPath(this.filename);
        valid |= this.validateNoPath(this.dispatchName);
        return valid |= this.validateNoPath(this.resourceQualifier);
    }

    private boolean validateNoPath(String s) {
        return !s.contains("/") && !s.contains("\\");
    }

    public String toString() {
        return "FileLocation(ecosystem=" + this.getEcosystem() + ", filename=" + this.getFilename() + ", dispatchName=" + this.getDispatchName() + ", resourceQualifier=" + this.getResourceQualifier() + ")";
    }

    public String getEcosystem() {
        return this.ecosystem;
    }

    public void setEcosystem(String ecosystem) {
        this.ecosystem = ecosystem;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDispatchName() {
        return this.dispatchName;
    }

    public void setDispatchName(String dispatchName) {
        this.dispatchName = dispatchName;
    }

    public String getResourceQualifier() {
        return this.resourceQualifier;
    }

    public void setResourceQualifier(String resourceQualifier) {
        this.resourceQualifier = resourceQualifier;
    }
}

