/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.manager.execenv;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.VersionInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.metaeffekt.artifact.resolver.manager.execenv.EnvironmentManagerConfig;
import org.metaeffekt.artifact.resolver.manager.execenv.EnvironmentParameters;
import org.metaeffekt.artifact.resolver.manager.execenv.StableExecutionEnvironment;
import org.metaeffekt.artifact.resolver.manager.execenv.exception.EnvironmentInitializationFailure;
import org.metaeffekt.core.container.control.kubernetesapi.NamespaceHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentManager<E extends StableExecutionEnvironment> {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentManager.class);
    private final LinkedHashMap<Object, E> environments = new LinkedHashMap(16, 0.75f, true);
    private final EnvironmentManagerConfig environmentManagerConfig;
    private final Config kubeconfig;
    private final NamespaceHandle namespaceHandle;

    public EnvironmentManager(EnvironmentManagerConfig environmentManagerConfig) {
        this.environmentManagerConfig = environmentManagerConfig;
        this.kubeconfig = null;
        this.namespaceHandle = new NamespaceHandle(this.kubeconfig);
        log.info("Namespace [{}] created.", (Object)this.namespaceHandle.getName());
        AtomicBoolean gracefulClosureFinished = new AtomicBoolean(false);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Namespace [{}] shutdown hook called. Attempting gracefully shutdown of environments...", (Object)this.namespaceHandle.getName());
            for (Map.Entry entry : this.environments.entrySet()) {
                Thread newThread = new Thread(() -> {
                    try {
                        ((StableExecutionEnvironment)entry.getValue()).close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Shutdown couldn't gracefully close environment", e);
                    }
                });
                newThread.start();
            }
            log.info("Namespace [{}] shutdown gracefully.", (Object)this.namespaceHandle.getName());
            gracefulClosureFinished.set(true);
        }));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                for (int i = 0; i < 100 && !gracefulClosureFinished.get(); ++i) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (!gracefulClosureFinished.get()) {
                log.info("Namespace [{}] shutdown timout. Killing environments...", (Object)this.namespaceHandle.getName());
            }
            try {
                this.namespaceHandle.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Shutdown hook: got exception while closing namespace handle", e);
            }
            log.info("Namespace [{}] closed.", (Object)this.namespaceHandle.getName());
        }));
    }

    private synchronized E constructNewEnvironment(EnvironmentParameters<? extends E> parameters) throws EnvironmentInitializationFailure {
        StableExecutionEnvironment execEnv;
        try {
            execEnv = (StableExecutionEnvironment)parameters.getEnvironmentClass().getDeclaredConstructor(Config.class, NamespaceHandle.class, parameters.getClass()).newInstance(this.kubeconfig, this.namespaceHandle, parameters);
            this.environments.put(parameters, execEnv);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new EnvironmentInitializationFailure("Error while instantiating environment via reflection", e);
        }
        return (E)execEnv;
    }

    public synchronized E getEnvironment(EnvironmentParameters<? extends E> parameters) throws EnvironmentInitializationFailure {
        if (this.environmentManagerConfig.getMaxEnvironments() == 0) {
            return null;
        }
        if (parameters == null) {
            return null;
        }
        StableExecutionEnvironment execEnv = (StableExecutionEnvironment)this.environments.get(parameters);
        if (execEnv == null) {
            log.debug("Creating new environment for parameters [{}].", parameters);
            if (this.environmentManagerConfig.getMaxEnvironments() != -1 && this.environments.size() >= this.environmentManagerConfig.getMaxEnvironments()) {
                Map.Entry oldest = (Map.Entry)this.environments.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Impossible: should have at least one object in this situation."));
                try {
                    ((StableExecutionEnvironment)this.environments.remove(oldest.getKey())).close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Environment closure failed unexpectedly", e);
                }
            }
            execEnv = this.constructNewEnvironment(parameters);
        }
        return (E)execEnv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkKubernetesAvailable(Config config) {
        log.info("Checking kubernetes availability. May take a while if unavailable.");
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(config).build();){
            VersionInfo versionInfo = client.getKubernetesVersion();
            log.debug("Detected Kubernetes version: {}.{}", (Object)versionInfo.getMajor(), (Object)versionInfo.getMinor());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.debug("Check request failed. Kubernetes environment is not available.", (Throwable)e);
            return false;
        }
    }

    public EnvironmentManagerConfig getEnvironmentManagerConfig() {
        return this.environmentManagerConfig;
    }

    public Config getKubeconfig() {
        return this.kubeconfig;
    }

    public NamespaceHandle getNamespaceHandle() {
        return this.namespaceHandle;
    }
}

