/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.maven;

import com.github.packageurl.PackageURL;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class MavenArtifactReference {
    private String artifactId;
    private String groupId;
    private String version;
    private String classifier;
    private String type;
    private String packaging;
    private String observedFileName;
    private String observedSha256;

    public MavenArtifactReference() {
    }

    public MavenArtifactReference(Artifact artifact) {
        String prefix;
        String ecosystem = artifact.get("Ecosystem");
        if (ecosystem != null && !"maven".equalsIgnoreCase(ecosystem)) {
            return;
        }
        artifact.deriveArtifactId();
        this.artifactId = artifact.getArtifactId();
        this.groupId = artifact.getGroupId();
        this.version = artifact.getVersion();
        this.classifier = artifact.getClassifier();
        this.type = artifact.getType();
        if ("maven".equalsIgnoreCase(ecosystem) && StringUtils.isEmpty((CharSequence)this.type)) {
            this.type = "jar";
        }
        this.observedFileName = artifact.getId();
        this.observedSha256 = artifact.get("Hash (SHA-256)");
        if (StringUtils.isNotEmpty((CharSequence)this.groupId) && this.artifactId.startsWith(prefix = this.groupId + ".")) {
            this.artifactId = this.artifactId.substring(prefix.length());
        }
    }

    public MavenArtifactReference(PackageURL packageURL) {
        if (packageURL.getType().equalsIgnoreCase("maven")) {
            this.artifactId = packageURL.getName();
            this.groupId = packageURL.getNamespace();
            this.version = packageURL.getVersion();
            if (packageURL.getQualifiers() != null) {
                this.classifier = (String)packageURL.getQualifiers().get("classifier");
                this.type = (String)packageURL.getQualifiers().get("type");
            }
        }
    }

    public MavenArtifactReference(MavenArtifactReference artifactReference, String classifier, String packaging) {
        this(artifactReference);
        this.type = this.modulateAttribute(artifactReference.type, packaging);
        this.classifier = this.modulateAttribute(artifactReference.classifier, classifier);
    }

    public MavenArtifactReference(MavenArtifactReference artifactReference) {
        this.artifactId = artifactReference.artifactId;
        this.groupId = artifactReference.groupId;
        this.version = artifactReference.version;
        this.classifier = artifactReference.classifier;
        this.type = artifactReference.type;
        this.packaging = artifactReference.packaging;
        this.observedFileName = artifactReference.observedFileName;
        this.observedSha256 = artifactReference.observedSha256;
    }

    private String modulateAttribute(String current, String modified) {
        if (modified != null) {
            if (modified.isEmpty()) {
                return null;
            }
            return modified;
        }
        return current;
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((CharSequence)this.artifactId) && StringUtils.isNotEmpty((CharSequence)this.groupId) && StringUtils.isNotEmpty((CharSequence)this.version) && !"*".equals(this.version);
    }

    public String deriveMavenDirectory() {
        StringBuilder mavenDirectory = new StringBuilder(this.getGroupId().replace(".", "/"));
        mavenDirectory.append("/").append(this.getArtifactId());
        mavenDirectory.append("/").append(this.getVersion());
        return mavenDirectory.toString();
    }

    public String deriveFileName() {
        StringBuilder name = new StringBuilder(this.getArtifactId());
        name.append("-").append(this.getVersion());
        if (this.getClassifier() != null) {
            name.append("-").append(this.getClassifier());
        }
        name.append(".").append(this.deriveType());
        return name.toString().replaceAll("\"", "");
    }

    private String deriveType() {
        if (this.type == null) {
            return "jar";
        }
        return this.type;
    }

    public FileLocation deriveFileLocation(String ecosystem) {
        FileLocation fileLocation = new FileLocation();
        fileLocation.setEcosystem(ecosystem);
        fileLocation.setFilename(this.deriveFileName());
        fileLocation.setDispatchName(this.getArtifactId());
        fileLocation.setResourceQualifier(this.deriveMavenDirectory().replace('/', '.'));
        if (!fileLocation.isValid()) {
            throw new IllegalStateException("File location invalid: " + fileLocation);
        }
        return fileLocation;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public void setObservedFileName(String observedFileName) {
        this.observedFileName = observedFileName;
    }

    public void setObservedSha256(String observedSha256) {
        this.observedSha256 = observedSha256;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getObservedFileName() {
        return this.observedFileName;
    }

    public String getObservedSha256() {
        return this.observedSha256;
    }

    public String toString() {
        return "MavenArtifactReference(artifactId=" + this.getArtifactId() + ", groupId=" + this.getGroupId() + ", version=" + this.getVersion() + ", classifier=" + this.getClassifier() + ", type=" + this.getType() + ", packaging=" + this.getPackaging() + ", observedFileName=" + this.getObservedFileName() + ", observedSha256=" + this.getObservedSha256() + ")";
    }
}

