/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.maven;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom2.JDOMException;
import org.metaeffekt.artifact.resolver.maven.MavenArtifactReference;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPomAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MavenPomAdapter.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean augmentLicenseMetaData(Artifact artifactToEnrich, MavenArtifactReference mavenArtifactReference, File pomFile) throws IOException, JDOMException {
        try (FileInputStream in = new FileInputStream(pomFile);){
            MavenArtifactReference parentRef;
            Model model = new MavenXpp3Reader().read((InputStream)in);
            String groupId = model.getGroupId();
            String version = model.getVersion();
            String artifactId = model.getArtifactId();
            String packaging = model.getPackaging();
            String name = model.getName();
            String description = model.getDescription();
            if ((version == null || groupId == null) && (parentRef = MavenPomAdapter.extractParentPom(model)) != null) {
                if (version == null) {
                    version = parentRef.getVersion();
                }
                if (groupId == null) {
                    groupId = parentRef.getGroupId();
                }
            }
            artifactToEnrich.setGroupId(groupId);
            artifactToEnrich.setVersion(version);
            artifactToEnrich.setComponent(name);
            if (StringUtils.isNotBlank((CharSequence)mavenArtifactReference.getType())) {
                packaging = mavenArtifactReference.getType();
            }
            String classifier = mavenArtifactReference.getClassifier();
            if (StringUtils.isNotBlank((CharSequence)packaging)) {
                if (StringUtils.isNotBlank((CharSequence)classifier)) {
                    artifactToEnrich.setId(artifactId + "-" + version + "-" + classifier + "." + packaging);
                } else {
                    artifactToEnrich.setId(artifactId + "-" + version + "." + packaging);
                }
            }
            artifactToEnrich.set("Description", description);
            String url = model.getUrl();
            if (StringUtils.isEmpty((CharSequence)artifactToEnrich.getUrl())) {
                artifactToEnrich.setUrl(url);
            }
            Organization organization = model.getOrganization();
            String organizationKey = "Organization";
            if (StringUtils.isEmpty((CharSequence)artifactToEnrich.get("Organization"))) {
                if (organization != null && StringUtils.isNotEmpty((CharSequence)organization.getUrl())) {
                    artifactToEnrich.setUrl(organization.getUrl());
                }
                if (organization != null && StringUtils.isNotEmpty((CharSequence)organization.getName())) {
                    artifactToEnrich.setUrl(organization.getName());
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.warn("Could not evaluate POM: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MavenArtifactReference extractParentPom(File pomFile) throws IOException {
        if (!pomFile.exists()) {
            return null;
        }
        try (FileInputStream in = new FileInputStream(pomFile);){
            Model model = new MavenXpp3Reader().read((InputStream)in);
            MavenArtifactReference mavenArtifactReference = MavenPomAdapter.extractParentPom(model);
            return mavenArtifactReference;
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static MavenArtifactReference extractParentPom(Model model) {
        Parent parent = model.getParent();
        if (parent != null) {
            try {
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put("packaging", "pom");
                return new MavenArtifactReference(new PackageURL("maven", parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), treeMap, null));
            }
            catch (MalformedPackageURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

