/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.maven;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractDownloadingAdapter;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.artifact.resolver.generic.utils.MarkerUtils;
import org.metaeffekt.artifact.resolver.maven.MavenArtifactReference;
import org.metaeffekt.artifact.resolver.maven.MavenArtifactResolverConfig;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRepositoryAdapter
extends AbstractDownloadingAdapter {
    private static final Logger log = LoggerFactory.getLogger(MavenRepositoryAdapter.class);
    protected static final Map<Integer, Duration> failureModeCodeToRetryDelay = new HashMap<Integer, Duration>(){
        {
            this.put(0, Duration.ofMinutes(5L));
            this.put(404, Duration.ofHours(24L));
            this.put(502, Duration.ofHours(1L));
            this.put(503, Duration.ofHours(1L));
            this.put(Integer.MIN_VALUE, Duration.ofSeconds(0L));
        }
    };
    private MavenArtifactResolverConfig resolverConfig;

    public MavenRepositoryAdapter(DownloadLocation downloadLocation, WebAccess webAccess, MavenArtifactResolverConfig resolverConfig) {
        super(downloadLocation, webAccess);
        this.resolverConfig = resolverConfig;
    }

    public ResolverResult resolvePom(MavenArtifactReference mavenArtifactReference) {
        return this.resolvePart(mavenArtifactReference, "", "pom");
    }

    public ResolverResult resolveBinaryArtifact(MavenArtifactReference mavenArtifactReference) {
        return this.resolvePart(mavenArtifactReference, null, null);
    }

    public ResolverResult resolveSourceArtifact(MavenArtifactReference mavenArtifactReference) {
        return this.resolvePart(mavenArtifactReference, "sources", "jar");
    }

    private ResolverResult resolvePart(MavenArtifactReference artifactReference, String classifierModifier, String packagingModifier) {
        MavenArtifactReference modulatedReference = new MavenArtifactReference(artifactReference, classifierModifier, packagingModifier);
        File file = this.downloadArtifact(modulatedReference);
        if (file != null && file.exists()) {
            return this.resolve(file, null);
        }
        return null;
    }

    public File downloadArtifact(MavenArtifactReference artifactRef) {
        if (this.resolverConfig != null && this.resolverConfig.getRepositoryBaseUrls() != null) {
            for (String repositoryBaseUrl : this.resolverConfig.getRepositoryBaseUrls()) {
                try {
                    File download = this.download(artifactRef, repositoryBaseUrl);
                    if (download == null) continue;
                    return download;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return null;
    }

    public boolean shouldRetry(@NonNull File markerFile, String uri, String targetPath) throws IOException {
        if (markerFile == null) {
            throw new NullPointerException("markerFile is marked non-null but is null");
        }
        String skipFailedDownloadFormatter = "Skipping failed download of [{}]. Recent attempt failed for file [{}].";
        if (!markerFile.exists()) {
            log.debug("Retrying by default since marker does not exist.");
            return true;
        }
        File failureModeInfoFile = new File(markerFile.getParentFile(), markerFile.getName() + ".failuremode");
        int retryCode = -1;
        try {
            String fmi;
            if (failureModeInfoFile.exists() && StringUtils.isNotBlank((CharSequence)(fmi = new String(Files.readAllBytes(failureModeInfoFile.toPath()), StandardCharsets.UTF_8).trim()))) {
                retryCode = Integer.parseInt(fmi);
            }
        }
        catch (Exception e) {
            log.error("Exception while trying to read failure mode info [{}]: [{}].", (Object)failureModeInfoFile.toPath(), (Object)e);
        }
        Duration toWait = retryCode != -1 ? failureModeCodeToRetryDelay.get(retryCode) : null;
        if (toWait == null) {
            log.debug("Error code [{}] not registered; reverting to old marker behaviour.", (Object)retryCode);
            if (MarkerUtils.hasRecentDownloadAttempt(markerFile)) {
                log.info("Skipping failed download of [{}]. Recent attempt failed for file [{}].", (Object)uri, (Object)targetPath);
                return false;
            }
            return true;
        }
        Instant lastModified = Files.getLastModifiedTime(markerFile.toPath(), new LinkOption[0]).toInstant();
        if (Instant.now().isBefore(lastModified.plus(toWait))) {
            log.info("Skipping failed download of [{}]. Recent attempt failed for file [{}]. (Decided with code [{}], total duration [{}]).", new Object[]{uri, targetPath, retryCode, toWait});
            return false;
        }
        return true;
    }

    private File download(@NonNull MavenArtifactReference artifactRef, String repositoryBaseUrl) throws IOException {
        if (artifactRef == null) {
            throw new NullPointerException("artifactRef is marked non-null but is null");
        }
        String mavenDirectory = artifactRef.deriveMavenDirectory();
        String filename = artifactRef.deriveFileName();
        FileLocation fileLocation = artifactRef.deriveFileLocation("maven");
        String uri = repositoryBaseUrl + mavenDirectory + "/" + filename;
        File targetFile = this.deriveDownloadFile(fileLocation);
        File markerFile = this.deriveMarkerFile(fileLocation, uri);
        File failureModeInfoFile = new File(markerFile.getParentFile(), markerFile.getName() + ".failuremode");
        if (!targetFile.exists()) {
            if (!this.shouldRetry(markerFile, uri, targetFile.getPath())) {
                log.trace("Determined we should not retry with shouldRetry.");
                return null;
            }
            this.removeMarker(markerFile);
            try (WebAccess.WebSession session = this.getWebAccess().createSession();){
                log.info("Downloading: [{}]", (Object)uri);
                Optional<File> downloadFile = session.downloadFile(uri, targetFile, httpResponse -> {
                    this.manageMarkerErrorResponseConsumer(markerFile).accept((HttpResponse)httpResponse);
                    if (httpResponse == null) {
                        log.info("HttpResponse null. returning.");
                        return;
                    }
                    if (httpResponse.getStatusLine() != null) {
                        try {
                            Files.createDirectories(failureModeInfoFile.getParentFile().toPath(), new FileAttribute[0]);
                            Files.write(failureModeInfoFile.toPath(), (httpResponse.getStatusLine().getStatusCode() + "\n").getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        }
                        catch (IOException e) {
                            log.warn("Could not write to failure mode info file [{}].", (Object)failureModeInfoFile);
                        }
                    } else {
                        log.info("Status line was null; could not deal with http response.");
                    }
                });
                if (!downloadFile.isPresent()) {
                    MarkerUtils.touchMarker(markerFile, artifactRef.toString());
                    Files.createDirectories(failureModeInfoFile.getParentFile().toPath(), new FileAttribute[0]);
                    Files.write(failureModeInfoFile.toPath(), "0\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                File file = downloadFile.orElse(null);
                return file;
            }
        }
        log.debug("Skipping successful download of [{}] for existing file [{}].", (Object)uri, (Object)targetFile.getPath());
        return targetFile;
    }
}

