/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.maven.attic;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractDownloadingAdapter;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.artifact.resolver.maven.MavenArtifactReference;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.core.util.FileUtils;
import org.springframework.util.Base64Utils;

public class MavenCentralAdapter
extends AbstractDownloadingAdapter {
    private static final Map<String, String> EC_CLASSIFIER_MAP = new HashMap<String, String>();
    private static final Map<String, String> EC_PACKAGING_MAP;

    public MavenCentralAdapter(DownloadLocation downloadLocation, WebAccess webAccess) {
        super(downloadLocation, webAccess);
    }

    public Set<MavenArtifactReference> queryArtifacts(MavenArtifactReference artifactReference) throws IOException {
        String serviceUrl = "https://search.maven.org/solrsearch/select";
        StringBuilder query = new StringBuilder("q=");
        boolean andRequired = false;
        if (artifactReference.getGroupId() != null) {
            if (andRequired) {
                query.append("+AND+");
            }
            query.append(this.replaceVar("g%3A%22${var}%22", artifactReference.getGroupId()));
            andRequired = true;
        }
        if (artifactReference.getArtifactId() != null) {
            if (andRequired) {
                query.append("+AND+");
            }
            query.append(this.replaceVar("a%3A%22${var}%22", artifactReference.getArtifactId()));
            andRequired = true;
        }
        String uri = "https://search.maven.org/solrsearch/select?" + query + "&core=gav&rows=20&wt=json";
        String encodedQuery = Base64Utils.encodeToString((byte[])query.toString().getBytes());
        FileLocation fileLocation = new FileLocation();
        fileLocation.setEcosystem("solrsearch");
        fileLocation.setFilename(encodedQuery);
        fileLocation.setResourceQualifier(artifactReference.deriveFileName());
        fileLocation.setDispatchName(artifactReference.deriveFileName());
        File file = this.deriveDownloadFile(fileLocation);
        File markerFile = this.deriveMarkerFile(fileLocation, "https://search.maven.org/solrsearch/select");
        this.getWebAccess().createSession().downloadFile(uri, file, this.manageMarkerErrorResponseConsumer(markerFile));
        if (file.exists()) {
            return this.parse(FileUtils.readFileToString((File)file, (String)"UTF-8"));
        }
        return null;
    }

    public Set<MavenArtifactReference> parse(String json) {
        JSONObject object = new JSONObject(json);
        JSONObject response = object.getJSONObject("response");
        JSONArray docs = response.getJSONArray("docs");
        HashSet<MavenArtifactReference> set = new HashSet<MavenArtifactReference>();
        for (int i = 0; i < docs.length(); ++i) {
            JSONObject doc = docs.getJSONObject(i);
            JSONArray classifiers = doc.getJSONArray("ec");
            for (int j = 0; j < classifiers.length(); ++j) {
                String classifier = EC_CLASSIFIER_MAP.get(classifiers.getString(j));
                String packaging = EC_PACKAGING_MAP.get(classifiers.getString(j));
                MavenArtifactReference artifactReference = new MavenArtifactReference();
                artifactReference.setPackaging(packaging);
                artifactReference.setArtifactId(doc.getString("a"));
                artifactReference.setGroupId(doc.getString("g"));
                artifactReference.setVersion(doc.getString("v"));
                artifactReference.setVersion(doc.getString("v"));
                artifactReference.setClassifier(classifier);
                set.add(artifactReference);
            }
        }
        return set;
    }

    private String replaceVar(String string, String value) {
        return string.replace("${var}", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convert(InputStream in, String encoding, boolean handleStream) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)in, (Writer)writer, (String)encoding);
            String string = writer.toString();
            return string;
        }
        finally {
            if (handleStream) {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    static {
        EC_CLASSIFIER_MAP.put(".pom", null);
        EC_CLASSIFIER_MAP.put(".jar", null);
        EC_CLASSIFIER_MAP.put("-sources.jar", "sources");
        EC_CLASSIFIER_MAP.put("-javadoc.jar", "javadoc");
        EC_CLASSIFIER_MAP.put(".zip", null);
        EC_CLASSIFIER_MAP.put(".tar.gz", null);
        EC_CLASSIFIER_MAP.put(".pdf", null);
        EC_CLASSIFIER_MAP.put("-doc.jar", "doc");
        EC_CLASSIFIER_MAP.put("-test.jar", "test");
        EC_CLASSIFIER_MAP.put("-tests.jar", "tests");
        EC_PACKAGING_MAP = new HashMap<String, String>();
        EC_PACKAGING_MAP.put(".pom", "pom");
        EC_PACKAGING_MAP.put(".jar", "jar");
        EC_PACKAGING_MAP.put("-sources.jar", "jar");
        EC_PACKAGING_MAP.put("-javadoc.jar", "jar");
        EC_PACKAGING_MAP.put(".zip", "zip");
        EC_PACKAGING_MAP.put(".tar.gz", "tar.gz");
        EC_PACKAGING_MAP.put(".pdf", "pdf");
        EC_PACKAGING_MAP.put("-doc.jar", "jar");
        EC_PACKAGING_MAP.put("-test.jar", "jar");
        EC_PACKAGING_MAP.put("-tests.jar", "jar");
    }
}

