/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.maven.index.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.metaeffekt.artifact.resolver.generic.index.lucene.AbstractLuceneIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLuceneIndexer
extends AbstractLuceneIndex {
    private static final Logger log = LoggerFactory.getLogger(MavenLuceneIndexer.class);
    private static final int INDEX_WRITER_MAX_RAM_BUFFER_SIZE_MB = 128;
    private static final String DEDUPLICATE = "DEDUPLICATE";
    private final IndexWriter writer;

    public MavenLuceneIndexer(@NonNull File directoryPath, @NonNull Analyzer analyzer) throws IOException {
        super(directoryPath, analyzer);
        if (directoryPath == null) {
            throw new NullPointerException("directoryPath is marked non-null but is null");
        }
        if (analyzer == null) {
            throw new NullPointerException("analyzer is marked non-null but is null");
        }
        IndexWriterConfig conf = new IndexWriterConfig(this.getAnalyzer());
        conf.setCommitOnClose(true);
        conf.setRAMBufferSizeMB(128.0);
        conf.setUseCompoundFile(false);
        this.writer = new IndexWriter(this.getDirectory(), conf);
    }

    public void addEntry(@NonNull Map<String, Collection<String>> keyValueMap) throws IOException {
        if (keyValueMap == null) {
            throw new NullPointerException("keyValueMap is marked non-null but is null");
        }
        Document document = new Document();
        if (keyValueMap.containsKey(DEDUPLICATE)) {
            log.error("Can't support key named [DEDUPLICATE]: key reserved by this class.");
            throw new IllegalArgumentException("Can't support key named [DEDUPLICATE]: key reserved by this class.");
        }
        for (Map.Entry<String, Collection<String>> entry : keyValueMap.entrySet()) {
            if (!StringUtils.equals((CharSequence)entry.getKey(), (CharSequence)"u")) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Skip unsupported key unequals 'u': [{}]", (Object)entry.getKey());
                continue;
            }
            for (String value : entry.getValue()) {
                String[] split = value.split("\\|");
                String groupId = split[0];
                String artifactId = split[1];
                String version = split[2];
                String classifier = split[3];
                String extensionOrPackaging = split[4];
                document.add((IndexableField)new TextField("g", groupId, Field.Store.YES));
                document.add((IndexableField)new TextField("a", artifactId, Field.Store.YES));
                document.add((IndexableField)new TextField("v", version, Field.Store.YES));
                document.add((IndexableField)new TextField("c", classifier, Field.Store.YES));
                document.add((IndexableField)new TextField("p", extensionOrPackaging, Field.Store.YES));
                String suffix = extensionOrPackaging;
                if (extensionOrPackaging.equalsIgnoreCase("module")) {
                    suffix = "jar";
                }
                String filename = artifactId + "-" + version + ("NA".equalsIgnoreCase(classifier) ? "" : "-" + classifier) + "." + suffix;
                document.add((IndexableField)new TextField("df", filename, Field.Store.YES));
                String extendedFilename = groupId + "." + artifactId + "-" + version + ("NA".equalsIgnoreCase(classifier) ? "" : "-" + classifier) + "." + suffix;
                document.add((IndexableField)new TextField("ef", extendedFilename, Field.Store.YES));
            }
        }
        this.writer.addDocument((Iterable)document);
    }

    public void clear() throws IOException {
        this.writer.deleteAll();
        this.writer.forceMergeDeletes(false);
        this.writer.commit();
    }

    public void commit() throws IOException {
        this.writer.commit();
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
        super.close();
    }
}

