/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.model;

import java.io.File;
import java.util.function.Function;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class ResolvedArtifactPart {
    private final File resolvedFile;
    private final Artifact originalArtifact;
    private Artifact enrichedArtifact;
    private final String error;
    private final ArtifactPartType artifactPartType;

    public ResolvedArtifactPart(File resolvedFile, String error, Artifact originalArtifact, ArtifactPartType artifactPartType) {
        this.resolvedFile = resolvedFile;
        this.error = error;
        this.originalArtifact = originalArtifact;
        this.artifactPartType = artifactPartType;
    }

    public ResolvedArtifactPart(ResolverResult resolverResult, Artifact originalArtifact, ArtifactPartType artifactPartType) {
        this(resolverResult.getResolvedFile(), resolverResult.getErrorMessage(), originalArtifact, artifactPartType);
    }

    void applyEnrichment(Function<ResolvedArtifactPart, Artifact> enrichmentFunction) {
        this.enrichedArtifact = enrichmentFunction.apply(this);
    }

    public File getResolvedFile() {
        return this.resolvedFile;
    }

    public Artifact getOriginalArtifact() {
        return this.originalArtifact;
    }

    public Artifact getEnrichedArtifact() {
        return this.enrichedArtifact;
    }

    public String getError() {
        return this.error;
    }

    public ArtifactPartType getArtifactPartType() {
        return this.artifactPartType;
    }
}

