/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.npm;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractDownloadingAdapter;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.npm.NpmArtifactReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmRepositoryAdapter
extends AbstractDownloadingAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(NpmRepositoryAdapter.class);

    public NpmRepositoryAdapter(DownloadLocation downloadLocation, WebAccess webAccess) {
        super(downloadLocation, webAccess);
    }

    private File downloadArtifact(NpmArtifactReference reference, String urlPart) {
        try {
            String repositoryUrl = "https://registry.npmjs.org/";
            File download = this.download(reference, "https://registry.npmjs.org/", urlPart);
            if (download != null) {
                return download;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private File download(NpmArtifactReference reference, String repositoryUrl, String urlPath) throws IOException {
        String uri = repositoryUrl + urlPath;
        FileLocation fileLocation = reference.deriveFileLocation();
        File file = this.deriveDownloadFile(fileLocation);
        File markerFile = this.deriveMarkerFile(fileLocation, repositoryUrl);
        if (!file.exists()) {
            if (uri.startsWith("http")) {
                if (this.hasRecentFailedDownloadAttempt(markerFile)) {
                    LOG.info("Skipping download [{}]. Recent attempt failed: [{}]", (Object)uri, (Object)file.getAbsolutePath());
                    return null;
                }
                this.removeMarker(markerFile);
                try (WebAccess.WebSession session = this.getWebAccess().createSession();){
                    LOG.info("Downloading: [{}]", (Object)uri);
                    Optional<File> downloadFile = session.downloadFile(uri, file, this.manageMarkerErrorResponseConsumer(markerFile));
                    File file2 = downloadFile.orElse(null);
                    return file2;
                }
            }
        } else {
            LOG.debug("Skipping download [{}]. File already exists: [{}]", (Object)uri, (Object)file.getAbsolutePath());
        }
        return file;
    }

    public ResolverResult resolveSourceArchive(NpmArtifactReference artifactReference) {
        File file = this.downloadArtifact(artifactReference, artifactReference.deriveUrlPart());
        return this.resolve(file, null);
    }
}

