/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.pypi;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.ArtifactResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolvers;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.model.ResolvedArtifactPart;
import org.metaeffekt.artifact.resolver.pypi.PyPIArtifactReference;
import org.metaeffekt.artifact.resolver.pypi.PyPICliAdapter;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class PyPIArtifactResolver
implements ArtifactResolver {
    private PyPICliAdapter pyPICliAdapter;

    public PyPIArtifactResolver(DownloadLocation downloadLocation) {
        this.pyPICliAdapter = new PyPICliAdapter(downloadLocation);
    }

    @Override
    public ArtifactPartResolvers collectResolvers(@NonNull Artifact artifact) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        HashSet<ArtifactPartResolver> parts = new HashSet<ArtifactPartResolver>();
        this.addArtifactResolverPartForPurl(parts, artifact);
        this.addArtifactResolverPartForNV(parts, artifact);
        return new ArtifactPartResolvers(parts);
    }

    private void addArtifactResolverPartForNV(Collection<ArtifactPartResolver> parts, Artifact artifact) {
        this.addPartResolvers(artifact, parts, new PyPIArtifactReference(artifact));
    }

    private void addPartResolvers(Artifact artifact, Collection<ArtifactPartResolver> parts, PyPIArtifactReference artifactReference) {
        if (artifactReference.isValid()) {
            parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.SOURCE_ARTIFACT, () -> this.pyPICliAdapter.resolveSourceArtifact(artifactReference), rap -> this.enrich(artifactReference, (ResolvedArtifactPart)rap)));
            parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.BINARY_ARTIFACT, () -> this.pyPICliAdapter.resolveBinaryArtifact(artifactReference), rap -> this.enrich(artifactReference, (ResolvedArtifactPart)rap)));
        }
    }

    private Artifact enrich(PyPIArtifactReference reference, ResolvedArtifactPart resolvedArtifactPart) {
        Artifact enrichedArtifact = new Artifact(resolvedArtifactPart.getOriginalArtifact());
        enrichedArtifact.setVersion(reference.getVersion());
        enrichedArtifact.setId(reference.getName() + "-" + reference.getVersion());
        File resolvedFile = resolvedArtifactPart.getResolvedFile();
        if (resolvedFile != null) {
            ArtifactPartType artifactPartType = resolvedArtifactPart.getArtifactPartType();
            enrichedArtifact.set(artifactPartType.modulatePathAttribute(), resolvedFile.getAbsolutePath());
        }
        return enrichedArtifact;
    }

    private void addArtifactResolverPartForPurl(Collection<ArtifactPartResolver> parts, Artifact artifact) {
        String purl = artifact.get("PURL");
        if (!StringUtils.isEmpty((CharSequence)purl)) {
            try {
                PyPIArtifactReference artifactReference = new PyPIArtifactReference(new PackageURL(purl));
                this.addPartResolvers(artifact, parts, artifactReference);
            }
            catch (MalformedPackageURLException e) {
                artifact.append("Errors", String.format("[PURL [%s] malformed.]", purl), "\n");
            }
        }
    }
}

