/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.rpm;

import com.github.packageurl.PackageURL;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class RpmArtifactReference {
    private String name;
    private String version;
    private String vendor;
    private String archOrSource;
    private String distro;
    private String epoch;

    public RpmArtifactReference(String name, String version, String vendor, String archOrSource, String distro, String epoch) {
        this.name = name;
        this.version = version;
        this.vendor = vendor;
        this.archOrSource = archOrSource;
        this.distro = distro;
        this.epoch = epoch;
    }

    public RpmArtifactReference(PackageURL packageURL) {
        if (packageURL.getType().equalsIgnoreCase("rpm")) {
            this.name = packageURL.getName();
            this.version = packageURL.getVersion();
            this.vendor = packageURL.getNamespace();
            if (packageURL.getQualifiers() != null) {
                this.archOrSource = (String)packageURL.getQualifiers().get("arch");
                this.archOrSource = (String)packageURL.getQualifiers().get("distro");
                this.archOrSource = (String)packageURL.getQualifiers().get("epoch");
            }
        }
    }

    public RpmArtifactReference(Artifact artifact) {
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((CharSequence)this.name) && StringUtils.isNotEmpty((CharSequence)this.version);
    }

    public FileLocation deriveFileLocation() {
        FileLocation fileLocation = new FileLocation();
        fileLocation.setEcosystem("rpm");
        String qualifier = this.getName() + "-" + this.getVersion();
        fileLocation.setFilename(qualifier);
        fileLocation.setResourceQualifier(qualifier);
        fileLocation.setDispatchName(this.getName());
        return fileLocation;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getArchOrSource() {
        return this.archOrSource;
    }

    public String getDistro() {
        return this.distro;
    }

    public String getEpoch() {
        return this.epoch;
    }
}

