/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.rpm;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.ArtifactResolver;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolvers;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.model.ResolvedArtifactPart;
import org.metaeffekt.artifact.resolver.rpm.RpmArtifactReference;
import org.metaeffekt.artifact.resolver.rpm.RpmRepositoryAdapter;
import org.metaeffekt.artifact.resolver.rpm.index.RpmIndexConfig;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class RpmArtifactResolver
implements ArtifactResolver {
    private RpmRepositoryAdapter repositoryAdapter;

    public RpmArtifactResolver(DownloadLocation downloadLocation, WebAccess webAccess, RpmIndexConfig rpmIndexConfig) {
        this.repositoryAdapter = new RpmRepositoryAdapter(downloadLocation, webAccess, rpmIndexConfig);
    }

    @Override
    public ArtifactPartResolvers collectResolvers(@NonNull Artifact artifact) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        HashSet<ArtifactPartResolver> parts = new HashSet<ArtifactPartResolver>();
        this.addArtifactResolverPartForPurl(parts, artifact);
        this.addArtifactResolverPartForNV(parts, artifact);
        return new ArtifactPartResolvers(parts);
    }

    private void addArtifactResolverPartForNV(Collection<ArtifactPartResolver> parts, Artifact artifact) {
        this.addPartResolvers(artifact, parts, new RpmArtifactReference(artifact));
    }

    private void addPartResolvers(Artifact artifact, Collection<ArtifactPartResolver> parts, RpmArtifactReference artifactReference) {
        if (artifactReference.isValid()) {
            parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.BINARY_ARTIFACT, () -> this.repositoryAdapter.resolveBinaryArtifact(artifactReference), arp -> this.enrich(artifactReference, (ResolvedArtifactPart)arp)));
            parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.SOURCE_ARTIFACT, () -> this.repositoryAdapter.resolveSourceArtifact(artifactReference), arp -> this.enrich(artifactReference, (ResolvedArtifactPart)arp)));
        }
    }

    private Artifact enrich(RpmArtifactReference reference, ResolvedArtifactPart resolverArtifactPart) {
        Artifact enrichedArtifact = new Artifact(resolverArtifactPart.getOriginalArtifact());
        enrichedArtifact.setVersion(reference.getVersion());
        enrichedArtifact.setId(reference.getName() + "-" + reference.getVersion());
        File resolvedFile = resolverArtifactPart.getResolvedFile();
        if (resolvedFile != null) {
            ArtifactPartType artifactPartType = resolverArtifactPart.getArtifactPartType();
            enrichedArtifact.set(artifactPartType.modulatePathAttribute(), resolvedFile.getAbsolutePath());
            Artifact metadataArtifact = this.repositoryAdapter.extractMetaData(resolvedFile);
            enrichedArtifact.merge(metadataArtifact);
        }
        return enrichedArtifact;
    }

    private void addArtifactResolverPartForPurl(Collection<ArtifactPartResolver> parts, Artifact artifact) {
        String purl = artifact.get("PURL");
        if (!StringUtils.isEmpty((CharSequence)purl)) {
            try {
                RpmArtifactReference artifactReference = new RpmArtifactReference(new PackageURL(purl));
                this.addPartResolvers(artifact, parts, artifactReference);
            }
            catch (MalformedPackageURLException e) {
                artifact.append("Errors", String.format("[PURL [%s] malformed.]", purl), "\n");
            }
        }
    }
}

