/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.rpm.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.metaeffekt.artifact.resolver.rpm.index.RpmIndexConfig;
import org.metaeffekt.artifact.resolver.rpm.index.RpmIndexPackageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpmIndex {
    private static final Logger LOG = LoggerFactory.getLogger(RpmIndex.class);
    private Map<String, Set<RpmIndexPackageData>> filenameToPackageDataMap = new HashMap<String, Set<RpmIndexPackageData>>();
    private Map<RpmIndexPackageData, Set<String>> packageDataUrlMap = new HashMap<RpmIndexPackageData, Set<String>>();

    public RpmIndex(RpmIndexConfig rpmIndexConfig) {
        if (rpmIndexConfig != null && rpmIndexConfig.getRawIndexPath() != null) {
            File indexFile = new File(rpmIndexConfig.getRawIndexPath());
            this.init(indexFile);
        }
    }

    private void init(File indexFile) {
        if (indexFile.exists()) {
            this.buildInternalMaps(indexFile);
        } else {
            LOG.warn("Configured rawIndexPath " + indexFile.getAbsolutePath() + " does not exit.");
        }
    }

    public RpmIndex(File indexFile) {
        this.init(indexFile);
    }

    private void buildInternalMaps(File indexFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(indexFile));){
            String url = reader.readLine();
            while (url != null) {
                if ((url = url.replaceAll("([^:])\\/\\/+", "$1/")).endsWith(".rpm")) {
                    RpmIndexPackageData rpmPackageData = new RpmIndexPackageData(url);
                    this.filenameToPackageDataMap.computeIfAbsent(rpmPackageData.getName(), a -> new HashSet()).add(rpmPackageData);
                    Set urls = this.packageDataUrlMap.computeIfAbsent(rpmPackageData, a -> new HashSet());
                    urls.add(url);
                }
                url = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Set<RpmIndexPackageData> queryPackageData(String rpmFilename) {
        return this.filenameToPackageDataMap.get(rpmFilename);
    }

    public Set<String> getRpmUrl(RpmIndexPackageData rpmPackageData) {
        return this.packageDataUrlMap.get(rpmPackageData);
    }
}

