/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.url;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractDownloadingAdapter;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.url.UrlArtifactReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlDownloadAdapter
extends AbstractDownloadingAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(UrlDownloadAdapter.class);

    public UrlDownloadAdapter(DownloadLocation downloadLocation, WebAccess webAccess) {
        super(downloadLocation, webAccess);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File download(UrlArtifactReference artifactReference, String url) {
        FileLocation fileLocation = artifactReference.deriveFileLocation();
        File file = this.deriveDownloadFile(fileLocation);
        File markerFile = this.deriveMarkerFile(fileLocation, fileLocation.getFilename());
        if (file.exists()) {
            LOG.debug("Skipping download [{}]. File already exists: " + file.getAbsolutePath(), (Object)url);
            return file;
        }
        if (!url.startsWith("http")) return file;
        if (this.hasRecentFailedDownloadAttempt(markerFile)) {
            LOG.info("Skipping download [{}]. Recent attempt failed:" + file.getAbsolutePath(), (Object)url);
            return null;
        }
        this.removeMarker(markerFile);
        try (WebAccess.WebSession session = this.getWebAccess().createSession();){
            LOG.info("Downloading: [{}]", (Object)url);
            Optional<File> downloadedFile = session.downloadFile(url, file, this.manageMarkerErrorResponseConsumer(markerFile));
            File file2 = downloadedFile.orElse(null);
            return file2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ResolverResult resolve(UrlArtifactReference artifactReference) {
        try {
            return this.resolve(this.download(artifactReference, artifactReference.getUrl()));
        }
        catch (Exception e) {
            return this.resolveWithError(artifactReference, e);
        }
    }
}

