/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.metaeffekt.common.notice.model;

import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.common.notice.utils.NoticeUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ComponentDefinition {

    private String name;

    private List<String> associatedLicenses;

    private List<String> effectiveLicenses;

    private List<String> copyrights;
    
    private String note;
    
    private boolean missingCopyrights;
    
    private boolean incompatibleWithSecondaryLicenses;
    
    private String componentStatus;

    private Map<String, String> variables;

    public ComponentDefinition(){
        associatedLicenses =new ArrayList<String>();
        copyrights = new ArrayList<String>();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAssociatedLicenses() {
        return associatedLicenses;
    }

    public void setAssociatedLicenses(List<String> associatedLicenses) {
        this.associatedLicenses = associatedLicenses;
    }

    public List<String> getCopyrights() {
        return copyrights;
    }

    public void setCopyrights(List<String> copyrights) {
        this.copyrights = NoticeUtils.normalizeCopyrights(copyrights);
    }
    
    public void setEffectiveLicenses(List<String> effectiveLicenses) {
        this.effectiveLicenses = effectiveLicenses;
    }

    public List<String> getEffectiveLicenses() {
        return effectiveLicenses;
    }

    public boolean hasCopyrights() {
        return copyrights != null && !copyrights.isEmpty();
    }

    public void setIncompatibleWithSecondaryLicenses(boolean incompatibleWithSecondaryLicenses) {
        this.incompatibleWithSecondaryLicenses = incompatibleWithSecondaryLicenses;
    }

    public boolean isMissingCopyrights() { return missingCopyrights; }
    
    public void setMissingCopyrights(boolean missingCopyrights) { this.missingCopyrights = missingCopyrights; }
    
    public boolean isIncompatibleWithSecondaryLicenses() {
        return incompatibleWithSecondaryLicenses;
    }

    // FIXME: the note must be rendered
    public String getNote() {return note;}

    public void setNote(String note) {
        this.note = note;
    }

    public boolean isNoteSet() {
        if (note == null) {
            return false;
        } else {
            return true;
        }
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public Map<String, String> getVariables() {
        return variables;
    }

    public String getVariable(String key) {
        String value = variables.get(key);
        if (StringUtils.isEmpty(value)) {
            throw new IllegalStateException(
                    String.format("Component definition %s does not specify variable '%s'", getName(), key));
        }
        return value;
    }

    public void setComponentStatus(String componentStatus) {
        this.componentStatus = componentStatus;
    }

    public String getComponentStatus() {
        return componentStatus;
    }

    @Override
    public String toString() {
        return "ComponentDefinition{" +
                "name='" + name + '\'' +
                ", associatedLicenses=" + associatedLicenses +
                ", effectiveLicenses=" + effectiveLicenses +
                ", copyrights=" + copyrights +
                ", incompatibleWithSecondaryLicenses=" + incompatibleWithSecondaryLicenses +
                ", variables=" + variables +
                ", componentStatus=" + componentStatus +
                '}';
    } 
    
    public String toStringKey() {
        return "name='" + name + '\'' +
                ", associatedLicenses=" + associatedLicenses +
                ", effectiveLicenses=" + effectiveLicenses +
                ", incompatibleWithSecondaryLicenses=" + incompatibleWithSecondaryLicenses +
                ", variables=" + variables +
                '}';
    }

}
