/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.metaeffekt.common.notice.model;

public class ProjectContext {

    public enum SourceMode {
        NONE,
        DISTRIBUTION_ANNEX,
        ON_DEMAND
    }
    
    public enum LanguageMode {
        en_US,
        de_DE
    }

    private SourceMode sourceMode = SourceMode.NONE;

    public void setSourceMode(SourceMode sourceMode) {
        this.sourceMode = sourceMode;
    }

    public SourceMode getSourceMode() {
        return sourceMode;
    }

    public boolean isSourceModeDistributionAnnex() {
        return SourceMode.DISTRIBUTION_ANNEX.equals(sourceMode);
    }

    public boolean isSourceModeOnDemand() {
        return SourceMode.ON_DEMAND.equals(sourceMode);
    }

    public boolean isSourceModeNone() {
        return SourceMode.NONE.equals(sourceMode);
    }

    public ProjectContext withSourceMode(SourceMode sourceMode) {
        this.setSourceMode(sourceMode);
        return this;
    }
    
    private LanguageMode languageMode = LanguageMode.en_US;

    public void setLanguageMode(LanguageMode languageMode) {
        this.languageMode = languageMode;
    }

    public LanguageMode getLanguageMode() {
        return languageMode;
    }
    
}

