/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.metaeffekt.common.notice.model;

import java.util.List;

public class UnassignedInformation {

    private List<String> copyrights;

    public void addCopyrights(List<String> unassignedCopyrights) {
        if (this.copyrights == null) {
            this.copyrights = unassignedCopyrights;
        } else {
            this.copyrights.addAll(unassignedCopyrights);
        } 
    }

    public void setCopyrights(List<String> copyrights) {
        this.copyrights = copyrights;
    }

    public List<String> getCopyrights() {
        return copyrights;
    }

    @Override
    public String toString() {
        return "UnassignedInformation{" +
                "copyrights=" + copyrights +
                '}';
    }
}
