/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.common.notice.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.common.notice.utils.NoticeUtils;

public class ComponentDefinition {
    private String name;
    private List<String> associatedLicenses = new ArrayList<String>();
    private List<String> effectiveLicenses;
    private List<String> copyrights = new ArrayList<String>();
    private String note;
    private boolean missingCopyrights;
    private boolean incompatibleWithSecondaryLicenses;
    private String componentStatus;
    private Map<String, String> variables;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAssociatedLicenses() {
        return this.associatedLicenses;
    }

    public void setAssociatedLicenses(List<String> associatedLicenses) {
        this.associatedLicenses = associatedLicenses;
    }

    public List<String> getCopyrights() {
        return this.copyrights;
    }

    public void setCopyrights(List<String> copyrights) {
        this.copyrights = NoticeUtils.normalizeCopyrights(copyrights);
    }

    public void setEffectiveLicenses(List<String> effectiveLicenses) {
        this.effectiveLicenses = effectiveLicenses;
    }

    public List<String> getEffectiveLicenses() {
        return this.effectiveLicenses;
    }

    public boolean hasCopyrights() {
        return this.copyrights != null && !this.copyrights.isEmpty();
    }

    public void setIncompatibleWithSecondaryLicenses(boolean incompatibleWithSecondaryLicenses) {
        this.incompatibleWithSecondaryLicenses = incompatibleWithSecondaryLicenses;
    }

    public boolean isMissingCopyrights() {
        return this.missingCopyrights;
    }

    public void setMissingCopyrights(boolean missingCopyrights) {
        this.missingCopyrights = missingCopyrights;
    }

    public boolean isIncompatibleWithSecondaryLicenses() {
        return this.incompatibleWithSecondaryLicenses;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean isNoteSet() {
        return this.note != null;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public String getVariable(String key) {
        String value = this.variables.get(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalStateException(String.format("Component definition %s does not specify variable '%s'", this.getName(), key));
        }
        return value;
    }

    public void setComponentStatus(String componentStatus) {
        this.componentStatus = componentStatus;
    }

    public String getComponentStatus() {
        return this.componentStatus;
    }

    public String toString() {
        return "ComponentDefinition{name='" + this.name + '\'' + ", associatedLicenses=" + this.associatedLicenses + ", effectiveLicenses=" + this.effectiveLicenses + ", copyrights=" + this.copyrights + ", incompatibleWithSecondaryLicenses=" + this.incompatibleWithSecondaryLicenses + ", variables=" + this.variables + ", componentStatus=" + this.componentStatus + '}';
    }

    public String toStringKey() {
        return "name='" + this.name + '\'' + ", associatedLicenses=" + this.associatedLicenses + ", effectiveLicenses=" + this.effectiveLicenses + ", incompatibleWithSecondaryLicenses=" + this.incompatibleWithSecondaryLicenses + ", variables=" + this.variables + '}';
    }
}

