/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.common.notice.model;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaeffekt.common.notice.model.ComponentDefinition;
import org.metaeffekt.common.notice.model.UnassignedInformation;
import org.metaeffekt.common.notice.utils.NoticeUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.representer.Representer;

public class NoticeParameters {
    private static final String NOTICE_PARAMETERS_REPRESENTATION = "!!" + NoticeParameters.class.getName();
    private static final String COMPONENT_DEFINITION_REPRESENTATION = "!!" + ComponentDefinition.class.getName();
    public static final Representer YAML_REPRESENTER = new Representer(){
        public static final String ATTRIBUTE_NAME = "name";
        public static final String ATTRIBUTE_COPYRIGHTS = "copyrights";

        protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
            MappingNode mappingNode = super.representJavaBean(properties, javaBean);
            NodeTuple nameNodeTuple = null;
            NodeTuple copyrightNodeTuple = null;
            HashSet<NodeTuple> disposableNodes = new HashSet<NodeTuple>();
            for (NodeTuple nodeTuple : mappingNode.getValue()) {
                ScalarNode svn;
                Node valueNode;
                Node keyNode = nodeTuple.getKeyNode();
                if (!(keyNode instanceof ScalarNode)) continue;
                ScalarNode sn = (ScalarNode)keyNode;
                if (ATTRIBUTE_NAME.equals(sn.getValue())) {
                    nameNodeTuple = nodeTuple;
                }
                if ((valueNode = nodeTuple.getValueNode()) instanceof ScalarNode) {
                    svn = (ScalarNode)valueNode;
                    if (svn.getValue() == null || svn.getValue().equals("null")) {
                        disposableNodes.add(nodeTuple);
                    } else if (svn.getValue().equals("false")) {
                        disposableNodes.add(nodeTuple);
                    }
                }
                if (!(valueNode instanceof SequenceNode)) continue;
                svn = (SequenceNode)valueNode;
                if (svn.getValue() == null || svn.getValue().isEmpty()) {
                    disposableNodes.add(nodeTuple);
                }
                if (!ATTRIBUTE_COPYRIGHTS.equals(sn.getValue())) continue;
                copyrightNodeTuple = nodeTuple;
            }
            if (nameNodeTuple != null) {
                mappingNode.getValue().remove(nameNodeTuple);
                mappingNode.getValue().add(0, nameNodeTuple);
            }
            if (copyrightNodeTuple != null) {
                mappingNode.getValue().remove(copyrightNodeTuple);
                mappingNode.getValue().add(copyrightNodeTuple);
            }
            mappingNode.getValue().removeAll(disposableNodes);
            return mappingNode;
        }
    };
    private String uri;
    private ComponentDefinition component;
    private List<ComponentDefinition> subcomponents = Collections.emptyList();
    private UnassignedInformation unassignedInformation;

    public ComponentDefinition getComponent() {
        return this.component;
    }

    public ComponentDefinition findComponent(ComponentDefinition component) {
        if (this.component.equals(component)) {
            return this.component;
        }
        for (ComponentDefinition subcomponent : this.subcomponents) {
            if (!subcomponent.equals(component)) continue;
            return subcomponent;
        }
        return null;
    }

    public List<String> getAllAssociatedLicense() {
        ArrayList<String> associatedLicenses = new ArrayList<String>();
        if (this.component != null) {
            associatedLicenses.addAll(this.component.getAssociatedLicenses());
        }
        if (this.subcomponents != null) {
            for (ComponentDefinition subcomponent : this.subcomponents) {
                associatedLicenses.addAll(subcomponent.getAssociatedLicenses());
            }
        }
        return associatedLicenses;
    }

    public List<ComponentDefinition> getSubcomponents() {
        return this.subcomponents;
    }

    public void setComponent(ComponentDefinition components) {
        this.component = components;
    }

    public void setSubcomponents(List<ComponentDefinition> subcomponents) {
        this.subcomponents = subcomponents;
    }

    public void setUnassignedInformation(UnassignedInformation unassignedInformation) {
        this.unassignedInformation = unassignedInformation;
    }

    public UnassignedInformation getUnassignedInformation() {
        return this.unassignedInformation;
    }

    public String toString() {
        return "NoticeParameters{uri='" + this.uri + '\'' + ", component=" + this.component + ", subcomponents=" + this.subcomponents + ", unassignedInformation=" + this.unassignedInformation + '}';
    }

    public static NoticeParameters readYaml(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            NoticeParameters param;
            NoticeParameters noticeParameters = param = (NoticeParameters)new Yaml().loadAs((Reader)reader, NoticeParameters.class);
            return noticeParameters;
        }
    }

    public static NoticeParameters readYaml(String string) {
        return (NoticeParameters)new Yaml().loadAs(string, NoticeParameters.class);
    }

    public String toYamlString() {
        String string = new Yaml(YAML_REPRESENTER).dumpAs((Object)this, null, DumperOptions.FlowStyle.BLOCK).replace(NOTICE_PARAMETERS_REPRESENTATION, "").trim();
        if (string.equals("null")) {
            return null;
        }
        if (string.equals("{}")) {
            return null;
        }
        if (string.equals("[]")) {
            return null;
        }
        return string;
    }

    public String toYamlComponentString() {
        String string = new Yaml(YAML_REPRESENTER).dumpAs((Object)this.component, null, DumperOptions.FlowStyle.BLOCK).replace(COMPONENT_DEFINITION_REPRESENTATION, "").trim();
        if (string.equals("null")) {
            return null;
        }
        if (string.equals("{}")) {
            return null;
        }
        if (string.equals("[]")) {
            return null;
        }
        return string;
    }

    public String toYamlSubcomponentsString() {
        String string = new Yaml(YAML_REPRESENTER).dumpAs(this.subcomponents, null, DumperOptions.FlowStyle.BLOCK).replace("- " + COMPONENT_DEFINITION_REPRESENTATION + "\n  ", "- ").trim();
        if (string.equals("null")) {
            return null;
        }
        if (string.equals("{}")) {
            return null;
        }
        if (string.equals("[]")) {
            return null;
        }
        return string;
    }

    public String getUri() {
        return this.uri;
    }

    public List<String> aggregateAssociatedLicenses() {
        HashSet<String> aggregated = new HashSet<String>();
        if (this.getComponent() != null) {
            aggregated.addAll(this.getComponent().getAssociatedLicenses());
        }
        if (this.getSubcomponents() != null) {
            for (ComponentDefinition componentDefinition : this.getSubcomponents()) {
                aggregated.addAll(componentDefinition.getAssociatedLicenses());
            }
        }
        return aggregated.stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList());
    }

    public List<String> aggregateCopyrights() {
        HashSet<String> aggregated = new HashSet<String>();
        if (this.unassignedInformation != null && this.unassignedInformation.getCopyrights() != null) {
            aggregated.addAll(this.unassignedInformation.getCopyrights());
        }
        if (this.component != null && this.component.getCopyrights() != null) {
            aggregated.addAll(this.component.getCopyrights());
        }
        for (ComponentDefinition componentDefinition : this.getSubcomponents()) {
            aggregated.addAll(componentDefinition.getCopyrights());
        }
        return NoticeUtils.normalizeCopyrights(aggregated);
    }
}

