/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.mirror.initializer;

import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.GitRepositoryDownload;

public class GitDownloadInitializer extends DownloadInitializer {

    /**
     * If set to true, the git command is used to clone the repository. Otherwise, the zip download is used.<br>
     * zip URLs have the following format: https://github.com/owner/repo/archive/refs/heads/main.zip
     */
    public boolean useGitCommand = false;

    @Override
    public void apply(Download download) {
        super.apply(download);

        if (download instanceof GitRepositoryDownload) {
            ((GitRepositoryDownload) download).setUseGitCommand(useGitCommand);
        }
    }
}
