/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.mirror.initializer;

import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.index.Index;

public abstract class MirrorInitializer<T extends Mirror> {

    public Integer lockFileTimeout;
    public boolean active = true;

    public void apply(T mirror) {
        if (mirror instanceof Index) {
            if (lockFileTimeout != null) {
                ((Index) mirror).setLockFileTimeout(lockFileTimeout);
            }
        } else if (mirror instanceof Download) {
            if (lockFileTimeout != null) {
                ((Download) mirror).setLockFileTimeout(lockFileTimeout);
            }
        }
    }
}
