/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.mirror.initializer;

import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.nvd.NvdCpeApiDownload;
import com.metaeffekt.mirror.download.nvd.NvdCveApiDownload;

public class NvdApiDownloadInitializer extends DownloadInitializer {

    public String apiKey;

    @Override
    public void apply(Download download) {
        super.apply(download);

        if (download instanceof NvdCveApiDownload) {
            final NvdCveApiDownload nvdCveApiDownload = (NvdCveApiDownload) download;
            nvdCveApiDownload.setApiKey(apiKey);
        } else if (download instanceof NvdCpeApiDownload) {
            final NvdCpeApiDownload nvdCpeApiDownload = (NvdCpeApiDownload) download;
            nvdCpeApiDownload.setApiKey(apiKey);
        } else {
            throw new IllegalArgumentException("Download [" + download.getClass().getSimpleName() + "] is not an instance of [" + NvdCveApiDownload.class.getSimpleName() + ", " + NvdCpeApiDownload.class.getSimpleName() + "]");
        }
    }
}
