/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.plugin;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.advisor.CertEuDownload;
import com.metaeffekt.mirror.download.advisor.CertFrDownload;
import com.metaeffekt.mirror.download.advisor.CertSeiDownload;
import com.metaeffekt.mirror.download.advisor.GhsaDownload;
import com.metaeffekt.mirror.download.advisor.MsrcDownload;
import com.metaeffekt.mirror.download.advisor.MsrcManualCsvDownload;
import com.metaeffekt.mirror.download.advisor.MsrcSecurityGuideDownload;
import com.metaeffekt.mirror.download.nvd.CpeDictionaryDownload;
import com.metaeffekt.mirror.download.nvd.NvdCpeApiDownload;
import com.metaeffekt.mirror.download.nvd.NvdCveApiDownload;
import com.metaeffekt.mirror.download.nvd.NvdDownload;
import com.metaeffekt.mirror.download.other.CisaKevDownload;
import com.metaeffekt.mirror.download.other.EolDownload;
import com.metaeffekt.mirror.download.other.EpssDownload;
import com.metaeffekt.mirror.index.Index;
import com.metaeffekt.mirror.index.advisor.CertEuAdvisorIndex;
import com.metaeffekt.mirror.index.advisor.CertFrAdvisorIndex;
import com.metaeffekt.mirror.index.advisor.CertSeiAdvisorIndex;
import com.metaeffekt.mirror.index.advisor.GhsaAdvisorIndex;
import com.metaeffekt.mirror.index.advisor.MsrcAdvisorIndex;
import com.metaeffekt.mirror.index.advisor.MsrcKbChainIndex;
import com.metaeffekt.mirror.index.advisor.MsrcProductIndex;
import com.metaeffekt.mirror.index.nvd.CpeDictionaryIndex;
import com.metaeffekt.mirror.index.nvd.CpeDictionaryVendorProductIndex;
import com.metaeffekt.mirror.index.nvd.NvdCpeApiIndex;
import com.metaeffekt.mirror.index.nvd.NvdCpeApiVendorProductIndex;
import com.metaeffekt.mirror.index.nvd.NvdCveApiIndex;
import com.metaeffekt.mirror.index.nvd.NvdVulnerabilityIndex;
import com.metaeffekt.mirror.index.other.EolIndex;
import com.metaeffekt.mirror.index.other.EpssIndex;
import com.metaeffekt.mirror.index.other.KevIndex;
import com.metaeffekt.mirror.initializer.CpeCorrectionConfig;
import com.metaeffekt.mirror.initializer.DownloadInitializer;
import com.metaeffekt.mirror.initializer.GitDownloadInitializer;
import com.metaeffekt.mirror.initializer.IndexInitializer;
import com.metaeffekt.mirror.initializer.MirrorInitializer;
import com.metaeffekt.mirror.initializer.NvdApiDownloadInitializer;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="data-mirror", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class DataMirrorMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File mirrorDirectory;
    @Parameter
    private String proxyScheme;
    @Parameter
    private String proxyHost;
    @Parameter
    private String proxyUsername;
    @Parameter
    private String proxyPassword;
    @Parameter
    private Integer proxyPort;
    @Parameter
    private boolean failOnIndexError = true;
    @Parameter
    private boolean failOnDownloadError = true;
    @Parameter
    private DownloadInitializer msrcDownload;
    @Deprecated
    @Parameter
    private DownloadInitializer msrcCsvDownload;
    @Parameter
    private DownloadInitializer msrcSecurityUpdateGuideDownload;
    @Deprecated
    @Parameter
    private DownloadInitializer cpeDictionaryDownload;
    @Parameter
    private NvdApiDownloadInitializer nvdCpeDownload;
    @Parameter
    private DownloadInitializer certSeiDownload;
    @Parameter
    private DownloadInitializer certFrDownload;
    @Parameter
    private DownloadInitializer certEuDownload;
    @Parameter
    private DownloadInitializer cisaKevDownload;
    @Parameter
    private DownloadInitializer epssDownload;
    @Parameter
    private DownloadInitializer eolDownload;
    @Deprecated
    @Parameter
    private DownloadInitializer nvdLegacyDownload;
    @Parameter
    private NvdApiDownloadInitializer nvdCveDownload;
    @Parameter
    private GitDownloadInitializer githubAdvisorDownload;
    @Parameter
    private IndexInitializer certSeiAdvisorIndex;
    @Parameter
    private IndexInitializer certEuAdvisorIndex;
    @Parameter
    private IndexInitializer certFrAdvisorIndex;
    @Deprecated
    @Parameter
    private IndexInitializer cpeDictionaryIndex;
    @Deprecated
    @Parameter
    private IndexInitializer cpeDictionaryVendorProductIndex;
    @Parameter
    private IndexInitializer nvdCpeIndex;
    @Parameter
    private IndexInitializer nvdCpeVendorProductIndex;
    @Parameter
    private IndexInitializer msrcProductIndex;
    @Parameter
    private IndexInitializer msrcAdvisorIndex;
    @Parameter
    private IndexInitializer msrcKbChainIndex;
    @Deprecated
    @Parameter
    private IndexInitializer nvdLegacyVulnerabilityIndex;
    @Parameter
    private IndexInitializer nvdVulnerabilityIndex;
    @Parameter
    private IndexInitializer githubAdvisorIndex;
    @Parameter
    private IndexInitializer kevIndex;
    @Parameter
    private IndexInitializer epssIndex;
    @Parameter
    private IndexInitializer eolIndex;
    @Parameter
    private List<CpeCorrectionConfig> cpeCorrections;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoFailureException {
        this.getLog().info((CharSequence)"Starting mirroring process");
        if (this.cpeCorrections != null) {
            LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
            for (CpeCorrectionConfig config : this.cpeCorrections) {
                mapping.put(config.getMalformedCpe(), config.getReplacementCpe());
            }
            CommonEnumerationUtil.putCorrectionConfig(mapping);
        }
        Map<Download, MirrorResult> downloadResults = this.processDownload();
        Map<Index, MirrorResult> indexResults = this.processIndex();
        this.logResults(downloadResults, indexResults);
        boolean downloadFailed = this.hasProcessFailed(downloadResults);
        boolean indexFailed = this.hasProcessFailed(indexResults);
        if (this.failOnIndexError && indexFailed) {
            throw new MojoFailureException("Mirroring process completed with errors - see log for details");
        }
        if (this.failOnDownloadError && downloadFailed) {
            throw new MojoFailureException("Mirroring process completed with errors - see log for details");
        }
        if (!indexFailed && !downloadFailed) {
            this.getLog().info((CharSequence)"Mirroring process completed successfully");
        } else {
            this.getLog().info((CharSequence)"Mirroring process completed with errors");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Download, MirrorResult> processDownload() {
        LinkedHashMap<Download, MirrorResult> mirrorResults = new LinkedHashMap<Download, MirrorResult>();
        List<Download> downloads = this.buildDownloaders();
        for (Download download : downloads) {
            MirrorResult result = mirrorResults.computeIfAbsent(download, d -> new MirrorResult());
            try {
                download.performDownloadIfRequired();
            }
            catch (Exception e) {
                result.exception = e;
                this.getLog().error((CharSequence)("Failed on download " + download.getDownloadIntoDirectory().getName()), (Throwable)e);
            }
            finally {
                result.stop();
                this.getLog().info((CharSequence)"");
            }
        }
        return mirrorResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Index, MirrorResult> processIndex() {
        LinkedHashMap<Index, MirrorResult> mirrorResults = new LinkedHashMap<Index, MirrorResult>();
        List<Index> indexes = this.buildIndexes();
        for (Index index : indexes) {
            MirrorResult result = mirrorResults.computeIfAbsent(index, d -> new MirrorResult());
            try {
                index.createIndexIfRequired();
            }
            catch (Exception e) {
                result.exception = e;
                this.getLog().error((CharSequence)("Failed on download " + index.getClass().getSimpleName()), (Throwable)e);
            }
            finally {
                result.stop();
                this.getLog().info((CharSequence)"");
            }
        }
        return mirrorResults;
    }

    private List<Download> buildDownloaders() {
        MsrcDownload download;
        ArrayList<Download> downloads = new ArrayList<Download>();
        if (this.isActive(this.msrcDownload)) {
            this.applyProxySettings(this.msrcDownload);
            download = new MsrcDownload(this.mirrorDirectory);
            this.msrcDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.msrcCsvDownload)) {
            this.applyProxySettings(this.msrcCsvDownload);
            download = new MsrcManualCsvDownload(this.mirrorDirectory);
            this.msrcCsvDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.msrcSecurityUpdateGuideDownload)) {
            this.applyProxySettings(this.msrcSecurityUpdateGuideDownload);
            download = new MsrcSecurityGuideDownload(this.mirrorDirectory);
            this.msrcSecurityUpdateGuideDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.cpeDictionaryDownload)) {
            this.applyProxySettings(this.cpeDictionaryDownload);
            download = new CpeDictionaryDownload(this.mirrorDirectory);
            this.cpeDictionaryDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.nvdCpeDownload)) {
            this.applyProxySettings(this.nvdCpeDownload);
            download = new NvdCpeApiDownload(this.mirrorDirectory);
            this.nvdCpeDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.certSeiDownload)) {
            this.applyProxySettings(this.certSeiDownload);
            download = new CertSeiDownload(this.mirrorDirectory);
            this.certSeiDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.certFrDownload)) {
            this.applyProxySettings(this.certFrDownload);
            download = new CertFrDownload(this.mirrorDirectory);
            this.certFrDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.certEuDownload)) {
            this.applyProxySettings(this.certEuDownload);
            download = new CertEuDownload(this.mirrorDirectory);
            this.certEuDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.cisaKevDownload)) {
            this.applyProxySettings(this.cisaKevDownload);
            download = new CisaKevDownload(this.mirrorDirectory);
            this.cisaKevDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.epssDownload)) {
            this.applyProxySettings(this.epssDownload);
            download = new EpssDownload(this.mirrorDirectory);
            this.epssDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.eolDownload)) {
            this.applyProxySettings(this.eolDownload);
            download = new EolDownload(this.mirrorDirectory);
            this.eolDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.githubAdvisorDownload)) {
            this.applyProxySettings(this.githubAdvisorDownload);
            download = new GhsaDownload(this.mirrorDirectory);
            this.githubAdvisorDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.nvdLegacyDownload)) {
            this.applyProxySettings(this.nvdLegacyDownload);
            download = new NvdDownload(this.mirrorDirectory);
            this.nvdLegacyDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (this.isActive(this.nvdCveDownload)) {
            this.applyProxySettings(this.nvdCveDownload);
            download = new NvdCveApiDownload(this.mirrorDirectory);
            this.nvdCveDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (!downloads.isEmpty()) {
            this.getLog().info((CharSequence)"Downloads:");
            for (Download download2 : downloads) {
                this.getLog().info((CharSequence)(" - " + Download.getDirectoryIdentifier(download2.getClass())));
            }
            this.getLog().info((CharSequence)"");
        }
        return downloads;
    }

    private List<Index> buildIndexes() {
        CertSeiAdvisorIndex index;
        ArrayList<Index> indexes = new ArrayList<Index>();
        if (this.isActive(this.certSeiAdvisorIndex)) {
            index = new CertSeiAdvisorIndex(this.mirrorDirectory);
            this.certSeiAdvisorIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.certFrAdvisorIndex)) {
            index = new CertFrAdvisorIndex(this.mirrorDirectory);
            this.certFrAdvisorIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.certEuAdvisorIndex)) {
            index = new CertEuAdvisorIndex(this.mirrorDirectory);
            this.certEuAdvisorIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.cpeDictionaryIndex)) {
            index = new CpeDictionaryIndex(this.mirrorDirectory);
            this.cpeDictionaryIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.cpeDictionaryVendorProductIndex)) {
            index = new CpeDictionaryVendorProductIndex(this.mirrorDirectory);
            this.cpeDictionaryVendorProductIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.nvdCpeIndex)) {
            index = new NvdCpeApiIndex(this.mirrorDirectory);
            this.nvdCpeIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.nvdCpeVendorProductIndex)) {
            index = new NvdCpeApiVendorProductIndex(this.mirrorDirectory);
            this.nvdCpeVendorProductIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.msrcProductIndex)) {
            index = new MsrcProductIndex(this.mirrorDirectory);
            this.msrcProductIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.msrcAdvisorIndex)) {
            index = new MsrcAdvisorIndex(this.mirrorDirectory);
            this.msrcAdvisorIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.msrcKbChainIndex)) {
            index = new MsrcKbChainIndex(this.mirrorDirectory);
            this.msrcKbChainIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.githubAdvisorIndex)) {
            index = new GhsaAdvisorIndex(this.mirrorDirectory);
            this.githubAdvisorIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.kevIndex)) {
            index = new KevIndex(this.mirrorDirectory);
            this.kevIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.epssIndex)) {
            index = new EpssIndex(this.mirrorDirectory);
            this.epssIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.eolIndex)) {
            index = new EolIndex(this.mirrorDirectory);
            this.eolIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.nvdLegacyVulnerabilityIndex)) {
            index = new NvdVulnerabilityIndex(this.mirrorDirectory);
            this.nvdLegacyVulnerabilityIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (this.isActive(this.nvdVulnerabilityIndex)) {
            index = new NvdCveApiIndex(this.mirrorDirectory);
            this.nvdVulnerabilityIndex.apply((Index)index);
            indexes.add((Index)index);
        }
        if (!indexes.isEmpty()) {
            this.getLog().info((CharSequence)"Indexes:");
            for (Index index2 : indexes) {
                this.getLog().info((CharSequence)(" - " + Index.getDirectoryIdentifier(index2.getClass())));
            }
            this.getLog().info((CharSequence)"");
        }
        return indexes;
    }

    private void applyProxySettings(DownloadInitializer initializer) {
        if (initializer.scheme != null || initializer.host != null || initializer.port != null || initializer.username != null || initializer.password != null) {
            this.getLog().info((CharSequence)("Downloader using initializer [" + initializer.getClass().getSimpleName() + "] already has proxy settings specified, ignoring global proxy settings"));
            return;
        }
        if (this.isValidProxySetting(this.proxyScheme)) {
            initializer.scheme = this.proxyScheme;
        }
        if (this.isValidProxySetting(this.proxyHost)) {
            initializer.host = this.proxyHost;
        }
        if (this.isValidProxySetting(this.proxyPort)) {
            initializer.port = this.proxyPort;
        }
        if (this.isValidProxySetting(this.proxyUsername)) {
            initializer.username = this.proxyUsername;
        }
        if (this.isValidProxySetting(this.proxyPassword)) {
            initializer.password = this.proxyPassword;
        }
    }

    private boolean isValidProxySetting(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (StringUtils.isEmpty((String)str)) {
                return false;
            }
            if (str.equalsIgnoreCase("null")) {
                return false;
            }
            if (str.equalsIgnoreCase("none")) {
                return false;
            }
        } else if (value instanceof Integer) {
            Integer i = (Integer)value;
            if (i == -1) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isActive(MirrorInitializer<?> initializer) {
        return initializer != null && initializer.active;
    }

    private boolean hasProcessFailed(Map<? extends Mirror, MirrorResult> results) {
        for (MirrorResult result : results.values()) {
            if (!result.hasFailed()) continue;
            return true;
        }
        return false;
    }

    private void logResults(Map<Download, MirrorResult> downloadResults, Map<Index, MirrorResult> indexResults) {
        this.getLog().info((CharSequence)"Mirror results:");
        if (!downloadResults.isEmpty()) {
            this.getLog().info((CharSequence)"Download:");
            for (Map.Entry<Download, MirrorResult> entry : downloadResults.entrySet()) {
                entry.getValue().logSummary(Download.getDirectoryIdentifier(entry.getKey().getClass()));
            }
            this.getLog().info((CharSequence)"");
        }
        if (!indexResults.isEmpty()) {
            this.getLog().info((CharSequence)"Index:");
            for (Map.Entry<Download, MirrorResult> entry : indexResults.entrySet()) {
                entry.getValue().logSummary(Index.getDirectoryIdentifier(((Index)entry.getKey()).getClass()));
            }
            this.getLog().info((CharSequence)"");
        }
        if (!downloadResults.isEmpty()) {
            for (Map.Entry<Download, MirrorResult> entry : downloadResults.entrySet()) {
                if (!entry.getValue().hasFailed()) continue;
                this.getLog().error((Throwable)entry.getValue().exception);
                this.getLog().error((CharSequence)"");
            }
        }
        if (!indexResults.isEmpty()) {
            for (Map.Entry<Download, MirrorResult> entry : indexResults.entrySet()) {
                if (!entry.getValue().hasFailed()) continue;
                this.getLog().error((Throwable)entry.getValue().exception);
                this.getLog().error((CharSequence)"");
            }
        }
    }

    private class MirrorResult {
        public Exception exception;
        private final long start = System.currentTimeMillis();
        private long duration = -1L;

        private MirrorResult() {
        }

        public void stop() {
            this.duration = System.currentTimeMillis() - this.start;
        }

        public String getDuration() {
            if (this.duration >= 0L) {
                if (this.duration < 1000L) {
                    return String.format("%4s ms", this.duration);
                }
                if (this.duration < 100000L) {
                    return String.format("%5.1f s", (double)this.duration / 1000.0);
                }
                return String.format("%5.0f s", (double)this.duration / 1000.0);
            }
            return "unknown";
        }

        public boolean hasFailed() {
            return this.exception != null;
        }

        public void logSummary(String name) {
            if (this.hasFailed()) {
                DataMirrorMojo.this.getLog().error((CharSequence)("- FAILED:  [" + this.getDuration() + "] " + name + ": " + this.exception.getMessage()));
            } else {
                DataMirrorMojo.this.getLog().info((CharSequence)("- SUCCESS: [" + this.getDuration() + "] " + name));
            }
        }
    }
}

