/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.plugin;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.advisor.CertFrDownload;
import com.metaeffekt.mirror.index.Index;
import com.metaeffekt.mirror.initializer.DownloadInitializer;
import com.metaeffekt.mirror.initializer.MirrorInitializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="internal-data-mirror", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class InternalDataPreprocessingMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File mirrorDirectory;
    @Parameter
    private String proxyScheme;
    @Parameter
    private String proxyHost;
    @Parameter
    private String proxyUsername;
    @Parameter
    private String proxyPassword;
    @Parameter
    private Integer proxyPort;
    @Parameter
    private DownloadInitializer certFrDownload;
    @Parameter(required=true)
    private File moveTargetFilesTo;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoFailureException {
        this.getLog().info((CharSequence)"Starting INTERNAL mirroring process");
        Map<Download, MirrorResult> downloadResults = this.processDownload();
        Map<Index, MirrorResult> indexResults = Collections.emptyMap();
        this.logResults(downloadResults, indexResults);
        if (this.hasProcessFailed(downloadResults, indexResults)) {
            throw new MojoFailureException("INTERNAL Mirroring process completed with errors - see log for details");
        }
        this.getLog().info((CharSequence)"INTERNAL Mirroring process completed successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Download, MirrorResult> processDownload() {
        LinkedHashMap<Download, MirrorResult> mirrorResults = new LinkedHashMap<Download, MirrorResult>();
        List<Download> downloads = this.buildDownloaders();
        if (!this.moveTargetFilesTo.getParentFile().exists()) {
            this.moveTargetFilesTo.mkdirs();
        }
        for (Download download : downloads) {
            MirrorResult result = mirrorResults.computeIfAbsent(download, d -> new MirrorResult());
            try {
                File internalMirrorTargetDir = new File(download.getDownloadIntoDirectory(), "internal-mirror");
                if (internalMirrorTargetDir.exists()) {
                    try {
                        FileUtils.forceDelete((File)internalMirrorTargetDir);
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("Failed to delete existing internal mirror directory " + internalMirrorTargetDir.getAbsolutePath()), (Throwable)e);
                        result.exception = e;
                        result.stop();
                        this.getLog().info((CharSequence)"");
                        continue;
                    }
                }
                download.performInternalDownload();
                if (!internalMirrorTargetDir.exists()) {
                    throw new RuntimeException("INTERNAL download failed - target directory was not provided by downloader, expected to exist: " + internalMirrorTargetDir.getAbsolutePath());
                }
                File moveTarget = new File(this.moveTargetFilesTo, Download.getDirectoryIdentifier(download.getClass()));
                if (moveTarget.exists()) {
                    try {
                        FileUtils.forceDelete((File)moveTarget);
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("Failed to delete existing move target directory " + moveTarget.getAbsolutePath()), (Throwable)e);
                        result.exception = e;
                        result.stop();
                        this.getLog().info((CharSequence)"");
                        continue;
                    }
                }
                FileUtils.moveDirectory((File)internalMirrorTargetDir, (File)moveTarget);
            }
            catch (Exception e) {
                result.exception = e;
                this.getLog().error((CharSequence)("Failed on download " + download.getDownloadIntoDirectory().getName()), (Throwable)e);
            }
            finally {
                result.stop();
                this.getLog().info((CharSequence)"");
            }
        }
        this.getLog().info((CharSequence)("Moved all internal mirror files to " + this.moveTargetFilesTo.getAbsolutePath()));
        this.getLog().info((CharSequence)"This directory can now be uploaded to a sever to be made available to other downloaders");
        return mirrorResults;
    }

    private List<Download> buildDownloaders() {
        ArrayList<Download> downloads = new ArrayList<Download>();
        if (this.isActive(this.certFrDownload)) {
            this.applyProxySettings(this.certFrDownload);
            CertFrDownload download = new CertFrDownload(this.mirrorDirectory);
            this.certFrDownload.apply((Download)download);
            downloads.add((Download)download);
        }
        if (!downloads.isEmpty()) {
            this.getLog().info((CharSequence)"Downloads:");
            for (Download download : downloads) {
                this.getLog().info((CharSequence)(" - " + Download.getDirectoryIdentifier(download.getClass())));
            }
            this.getLog().info((CharSequence)"");
        }
        return downloads;
    }

    private void applyProxySettings(DownloadInitializer initializer) {
        if (initializer.scheme != null || initializer.host != null || initializer.port != null || initializer.username != null || initializer.password != null) {
            this.getLog().info((CharSequence)("Downloader using initializer [" + initializer.getClass().getSimpleName() + "] already has proxy settings specified, ignoring global proxy settings"));
            return;
        }
        if (this.isValidProxySetting(this.proxyScheme)) {
            initializer.scheme = this.proxyScheme;
        }
        if (this.isValidProxySetting(this.proxyHost)) {
            initializer.host = this.proxyHost;
        }
        if (this.isValidProxySetting(this.proxyPort)) {
            initializer.port = this.proxyPort;
        }
        if (this.isValidProxySetting(this.proxyUsername)) {
            initializer.username = this.proxyUsername;
        }
        if (this.isValidProxySetting(this.proxyPassword)) {
            initializer.password = this.proxyPassword;
        }
    }

    private boolean isValidProxySetting(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (StringUtils.isEmpty((String)str)) {
                return false;
            }
            if (str.equalsIgnoreCase("null")) {
                return false;
            }
            if (str.equalsIgnoreCase("none")) {
                return false;
            }
        } else if (value instanceof Integer) {
            Integer i = (Integer)value;
            if (i == -1) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isActive(MirrorInitializer<?> initializer) {
        return initializer != null && initializer.active;
    }

    private boolean hasProcessFailed(Map<Download, MirrorResult> downloadResults, Map<Index, MirrorResult> indexResults) {
        for (MirrorResult result : downloadResults.values()) {
            if (!result.hasFailed()) continue;
            return true;
        }
        for (MirrorResult result : indexResults.values()) {
            if (!result.hasFailed()) continue;
            return true;
        }
        return false;
    }

    private void logResults(Map<Download, MirrorResult> downloadResults, Map<Index, MirrorResult> indexResults) {
        this.getLog().info((CharSequence)"Mirror results:");
        if (!downloadResults.isEmpty()) {
            this.getLog().info((CharSequence)"Download:");
            for (Map.Entry<Download, MirrorResult> entry : downloadResults.entrySet()) {
                entry.getValue().logSummary(Download.getDirectoryIdentifier(entry.getKey().getClass()));
            }
            this.getLog().info((CharSequence)"");
        }
        if (!indexResults.isEmpty()) {
            this.getLog().info((CharSequence)"Index:");
            for (Map.Entry<Download, MirrorResult> entry : indexResults.entrySet()) {
                entry.getValue().logSummary(Index.getDirectoryIdentifier(((Index)entry.getKey()).getClass()));
            }
            this.getLog().info((CharSequence)"");
        }
        if (!downloadResults.isEmpty()) {
            for (Map.Entry<Download, MirrorResult> entry : downloadResults.entrySet()) {
                if (!entry.getValue().hasFailed()) continue;
                this.getLog().error((Throwable)entry.getValue().exception);
                this.getLog().error((CharSequence)"");
            }
        }
        if (!indexResults.isEmpty()) {
            for (Map.Entry<Download, MirrorResult> entry : indexResults.entrySet()) {
                if (!entry.getValue().hasFailed()) continue;
                this.getLog().error((Throwable)entry.getValue().exception);
                this.getLog().error((CharSequence)"");
            }
        }
    }

    private class MirrorResult {
        public Exception exception;
        private final long start = System.currentTimeMillis();
        private long duration = -1L;

        private MirrorResult() {
        }

        public void stop() {
            this.duration = System.currentTimeMillis() - this.start;
        }

        public String getDuration() {
            if (this.duration >= 0L) {
                if (this.duration < 1000L) {
                    return String.format("%4s ms", this.duration);
                }
                if (this.duration < 100000L) {
                    return String.format("%5.1f s", (double)this.duration / 1000.0);
                }
                return String.format("%5.0f s", (double)this.duration / 1000.0);
            }
            return "unknown";
        }

        public boolean hasFailed() {
            return this.exception != null;
        }

        public void logSummary(String name) {
            if (this.hasFailed()) {
                InternalDataPreprocessingMojo.this.getLog().error((CharSequence)("- FAILED:  [" + this.getDuration() + "] " + name + ": " + this.exception.getMessage()));
            } else {
                InternalDataPreprocessingMojo.this.getLog().info((CharSequence)("- SUCCESS: [" + this.getDuration() + "] " + name));
            }
        }
    }
}

