/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.initializer;

import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.initializer.MirrorInitializer;
import java.util.LinkedHashMap;
import java.util.Map;

public class DownloadInitializer
extends MirrorInitializer<Download> {
    final Map<String, String> resourceLocations = new LinkedHashMap<String, String>();
    public String scheme;
    public String host;
    public String username;
    public String password;
    public Integer port;
    public Integer maxAgeBeforeRecheck;
    public Integer maxAgeBeforeReset;
    public boolean applyProxyInformation = true;

    @Override
    public void apply(Download download) {
        for (Map.Entry<String, String> location : this.resourceLocations.entrySet()) {
            download.setRemoteResourceLocation(location.getKey(), location.getValue());
        }
        if (this.applyProxyInformation && this.scheme != null && this.host != null && this.port != null && this.username != null && this.password != null) {
            download.setDownloaderProxyCredentials(this.scheme, this.host, this.port.intValue(), this.username, this.password);
        }
        if (this.maxAgeBeforeRecheck != null) {
            download.setMaxAgeBeforeRecheck((long)this.maxAgeBeforeRecheck.intValue());
        }
        if (this.maxAgeBeforeReset != null) {
            download.setMaxAgeBeforeReset((long)this.maxAgeBeforeReset.intValue());
        }
    }
}

