/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.notice;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.metaeffekt.common.notice.model.ComponentDefinition;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.common.notice.model.ProjectContext;
import org.metaeffekt.core.inventory.InventoryUtils;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.LicenseMetaData;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.notice.engine.NoticeEngine;
import org.metaeffekt.notice.engine.utils.NoticeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeParameterProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(NoticeParameterProcessor.class);
    private final NoticeUtils noticeUtils;

    public NoticeParameterProcessor(NormalizationMetaData normalizationMetaData) {
        this.noticeUtils = new NoticeUtils(normalizationMetaData);
    }

    public void updateNoticeFromNoticeParameter(Inventory inventory) {
        this.updateNoticeFromNoticeParameter(inventory, null);
    }

    public void updateNoticeFromNoticeParameter(Inventory inventory, ProjectContext projectContext) {
        String noticeParameterYaml;
        NoticeEngine noticeEngine = new NoticeEngine();
        if (projectContext != null) {
            noticeEngine.setProjectContext(projectContext);
        }
        if (inventory == null || inventory.getArtifacts() == null) {
            return;
        }
        ArrayList<Artifact> secondPass = new ArrayList<Artifact>();
        for (Artifact artifact : inventory.getArtifacts()) {
            if (!com.metaeffekt.artifact.analysis.utils.InventoryUtils.canCarryLicenseMetaData((Artifact)artifact) || !StringUtils.notEmpty((String)(noticeParameterYaml = artifact.get("Notice Parameter")))) continue;
            if (artifact.getVersion().startsWith("${") || artifact.getVersion().equals("*")) {
                this.generateNoticeFromNoticeParameter(inventory, noticeEngine, artifact, noticeParameterYaml);
                continue;
            }
            secondPass.add(artifact);
        }
        for (Artifact artifact : secondPass) {
            if (!com.metaeffekt.artifact.analysis.utils.InventoryUtils.canCarryLicenseMetaData((Artifact)artifact) || !StringUtils.notEmpty((String)(noticeParameterYaml = artifact.get("Notice Parameter")))) continue;
            this.generateNoticeFromNoticeParameter(inventory, noticeEngine, artifact, noticeParameterYaml);
        }
    }

    private void generateNoticeFromNoticeParameter(Inventory inventory, NoticeEngine noticeEngine, Artifact artifact, String noticeParameterYaml) {
        try {
            NoticeParameters parameter = this.readNoticeParameter(noticeParameterYaml);
            if (StringUtils.notEmpty((String)artifact.getComponent())) {
                ComponentDefinition component = parameter.getComponent();
                if (component == null) {
                    component = new ComponentDefinition();
                    parameter.setComponent(component);
                }
                component.setName(artifact.getComponent());
            }
            ComponentDefinition componentDefinition = parameter.getComponent();
            this.updateEffectiveLicense(componentDefinition);
            if (parameter.getSubcomponents() != null) {
                for (ComponentDefinition subComponentDefinition : parameter.getSubcomponents()) {
                    this.updateEffectiveLicense(subComponentDefinition);
                }
            }
            String notice = noticeEngine.applyTemplate(parameter, this.noticeUtils.getNormalizationMetaData());
            LicenseMetaData licenseMetaData = this.resolveOrCreateLicenseMetadata(inventory, artifact, parameter);
            if (StringUtils.notEmpty((String)notice)) {
                licenseMetaData.setNotice(notice);
                this.addLicenseMetaData(inventory, artifact, licenseMetaData);
            } else {
                LOG.warn("No notice parameter for artifact [{}]. Cannot create notice.", (Object)artifact.deriveQualifier());
            }
        }
        catch (Exception e) {
            LOG.error("Cannot process notice parameter for [{}]. Reason: [{}]", (Object)artifact.getId(), (Object)e.getMessage());
        }
    }

    private void addLicenseMetaData(Inventory inventory, Artifact artifact, LicenseMetaData licenseMetaData) {
        if (inventory.findMatchingLicenseMetaData(artifact) == null) {
            if (licenseMetaData.getVersion() == null) {
                throw new IllegalStateException("Version is null in " + artifact.getId() + ".");
            }
            if (licenseMetaData.getLicense() == null) {
                throw new IllegalStateException("License is null in " + artifact.getId() + ".");
            }
            if (licenseMetaData.getComponent() == null) {
                throw new IllegalStateException("Component is null in " + artifact.getId() + ".");
            }
            LOG.debug("Adding license metadata for {}/{}/{}.", new Object[]{artifact.getComponent(), artifact.getLicense(), artifact.getVersion()});
            inventory.getLicenseMetaData().add(licenseMetaData);
            try {
                inventory.findMatchingLicenseMetaData(artifact);
            }
            catch (Exception e) {
                inventory.getLicenseMetaData().remove(licenseMetaData);
                LOG.error("Inconsistency detected after creating license metadata for [{}].", (Object)artifact.deriveQualifier());
            }
        }
    }

    private void updateEffectiveLicense(ComponentDefinition componentDefinition) {
        List effectiveLicenses = componentDefinition.getEffectiveLicenses();
        if (effectiveLicenses == null || effectiveLicenses.isEmpty()) {
            List associatedLicenses = componentDefinition.getAssociatedLicenses();
            String s = com.metaeffekt.artifact.analysis.utils.InventoryUtils.deriveEffectiveLicenses((Collection)associatedLicenses);
            componentDefinition.setEffectiveLicenses(Arrays.asList(s.split("\\|")));
        }
    }

    public LicenseMetaData resolveOrCreateLicenseMetadata(Inventory inventory, Artifact artifact, NoticeParameters noticeParameter) {
        LicenseMetaData licenseMetaData = null;
        if (StringUtils.notEmpty((String)artifact.getComponent()) && StringUtils.hasText((String)artifact.getVersion()) && StringUtils.hasText((String)artifact.getLicense())) {
            licenseMetaData = inventory.findMatchingLicenseMetaData(artifact);
        }
        if (licenseMetaData == null) {
            licenseMetaData = new LicenseMetaData();
            licenseMetaData.setComponent(artifact.getComponent());
            licenseMetaData.setLicense(artifact.getLicense());
            if (artifact.getVersion().startsWith("${")) {
                licenseMetaData.setVersion("*");
            } else {
                licenseMetaData.setVersion(artifact.getVersion());
            }
            licenseMetaData.set("Type", "automatic");
            if (noticeParameter != null) {
                licenseMetaData.setLicenseInEffect(InventoryUtils.joinEffectiveLicenses(this.noticeUtils.getEffectiveLicenses(noticeParameter)));
            } else {
                licenseMetaData.setLicenseInEffect(com.metaeffekt.artifact.analysis.utils.InventoryUtils.deriveEffectiveLicenses((String)artifact.getLicense()));
            }
        }
        return licenseMetaData;
    }

    public void validateNoticeParameter(File inventoryFile) throws IOException {
        Inventory inventory = new InventoryReader().readInventory(inventoryFile);
        this.validateNoticeParameter(inventory);
    }

    public void validateNoticeParameter(Inventory inventory) {
        for (Artifact artifact : inventory.getArtifacts()) {
            String noticeParameterYaml = artifact.get("Notice Parameter");
            if (!StringUtils.notEmpty((String)noticeParameterYaml)) continue;
            try {
                this.readNoticeParameter(noticeParameterYaml);
            }
            catch (Exception e) {
                LOG.error("Error parsing artifact {}.", (Object)artifact.getId());
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public NoticeParameters readNoticeParameter(String noticeParameterYaml) {
        noticeParameterYaml = noticeParameterYaml.replaceAll("\n\\.\\.\\.\\.", "\n    ");
        noticeParameterYaml = noticeParameterYaml.replaceAll("\n\\.\\.", "\n  ");
        char nbsp = '\u00a0';
        char sp = '\n';
        noticeParameterYaml = noticeParameterYaml.replace(nbsp, sp);
        noticeParameterYaml = noticeParameterYaml.replaceAll("\\s\n", "\n");
        return NoticeParameters.readYaml((String)noticeParameterYaml);
    }
}

