/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.notice.engine;

import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.common.notice.model.ProjectContext;
import org.metaeffekt.core.inventory.processor.report.PreFormattedEscapeUtils;
import org.metaeffekt.notice.engine.utils.NoticeUtils;

public class NoticeEngine {
    private VelocityEngine velocityEngine;
    private Template template;
    private transient VelocityContext velocityContext;
    private final File fileResourcePath;
    private ProjectContext projectContext = new ProjectContext();

    public NoticeEngine() {
        this.fileResourcePath = null;
    }

    public NoticeEngine(File fileResourcePath) {
        this.fileResourcePath = fileResourcePath;
    }

    public String applyTemplate(File noticeInputDefinition, NormalizationMetaData normalizationMetaData) throws IOException {
        return this.applyTemplate(NoticeParameters.readYaml((File)noticeInputDefinition), normalizationMetaData);
    }

    public String applyTemplate(NoticeParameters param, NormalizationMetaData normalizationMetaData) {
        this.initializeVelocityEngineAndTemplate();
        this.initializeVelocityContext(param, normalizationMetaData);
        StringWriter stringWriter = new StringWriter();
        this.template.merge((Context)this.velocityContext, (Writer)stringWriter);
        return this.postprocess(stringWriter.getBuffer().toString());
    }

    private void initializeVelocityContext(NoticeParameters param, NormalizationMetaData normalizationMetaData) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("engine", this);
        contextMap.put("context", new NoticeUtils(normalizationMetaData));
        contextMap.put("noticeParameters", param);
        contextMap.put("escape", new PreFormattedEscapeUtils());
        contextMap.put("projectContext", this.projectContext);
        this.velocityContext = new VelocityContext(contextMap);
    }

    private synchronized void initializeVelocityEngineAndTemplate() {
        if (this.velocityEngine == null) {
            Properties properties = new Properties();
            if (this.fileResourcePath == null) {
                properties.put("class.resource.loader.class", ClasspathResourceLoader.class.getName());
            } else {
                properties.put("file.resource.loader.path", this.fileResourcePath.getAbsolutePath());
            }
            properties.put("resource.loader", "class, file");
            properties.put("input.encoding", "UTF-8");
            properties.put("output.encoding", "UTF-8");
            properties.put("directive.set.null.allowed", (Object)true);
            this.velocityEngine = new VelocityEngine(properties);
            this.velocityEngine.init();
            this.template = this.velocityEngine.getTemplate("notice-template/template.vm");
        }
    }

    private String postprocess(String string) {
        string = string.trim();
        string = string.replaceAll("<lines>\\s*<line>", "<lines><line>");
        string = string.replaceAll("</line>\\s*</lines>", "</line></lines>");
        string = string.replaceAll("</line>\\s*<line>", "</line>\n<line>");
        int index = (string = string.replaceAll("<p/>\\s*<p/>", "<p/>")).lastIndexOf("<p/>");
        if (index >= 0 && string.substring(index).trim().equals("<p/>")) {
            string = string.substring(0, index);
        }
        string = string.replaceAll("\n\\s*<p>", "\n<p>");
        string = string.replaceAll("\n\\s*([^<])", " $1");
        return string;
    }

    public String executeTemplate(String file) {
        Template template = this.velocityEngine.getTemplate(file);
        StringWriter writer = new StringWriter();
        template.merge((Context)this.velocityContext, (Writer)writer);
        return writer.getBuffer().toString();
    }

    public void setProjectContext(ProjectContext projectContext) {
        this.projectContext = projectContext;
    }

    public ProjectContext getProjectContext() {
        return this.projectContext;
    }

    public boolean resourceExists(String resource) {
        return this.velocityEngine.resourceExists(resource);
    }
}

