/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.notice.engine;

import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.util.Map;
import java.util.Objects;
import org.metaeffekt.common.notice.model.ComponentDefinition;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.notice.engine.NoticeParameterValidationContext;
import org.metaeffekt.notice.engine.utils.NoticeUtils;

public class NoticeParameterValidator {
    private final NormalizationMetaData normalizationMetaData;
    private final NoticeUtils noticeUtils;

    public NoticeParameterValidator(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
        this.noticeUtils = new NoticeUtils(normalizationMetaData);
    }

    public void validateNoticeParameter(NoticeParameters noticeParameters, NoticeParameterValidationContext context) {
        ComponentDefinition mainComponent = noticeParameters.getComponent();
        this.validateMainComponentDefinition(mainComponent, context);
        this.validateComponentDefinition(mainComponent, context);
        for (ComponentDefinition subcomponent : noticeParameters.getSubcomponents()) {
            this.validateComponentDefinition(subcomponent, context);
        }
        for (ContextError contextError : context.getMessages()) {
            switch (contextError.type) {
                case ERROR: {
                    context.error(contextError.message);
                    break;
                }
                case WARNING: {
                    context.warn(contextError.message);
                    break;
                }
                case INFO: {
                    context.info(contextError.message);
                }
            }
        }
    }

    public void validateComponentDefinition(ComponentDefinition componentDefinition, NoticeParameterValidationContext context) {
        if (componentDefinition == null) {
            return;
        }
        String componentDefinitionId = componentDefinition.getName() != null ? componentDefinition.getName() : this.noticeUtils.getEffectiveLicenses(componentDefinition).toString();
        this.noticeParameterStatus(componentDefinition, componentDefinitionId, context);
        this.validateCopyrights(componentDefinition, componentDefinitionId, context);
        this.validateNote(componentDefinition, componentDefinitionId, context);
        this.validateVariables(componentDefinition, componentDefinitionId, context);
        this.validateLicenses(componentDefinition, componentDefinitionId, context);
    }

    public void validateMainComponentDefinition(ComponentDefinition componentDefinition, NoticeParameterValidationContext context) {
        if (componentDefinition == null) {
            context.error("The main component is not defined! Hint: Add a main component to the notice parameter.");
        } else if (componentDefinition.getName() == null || componentDefinition.getName().isEmpty()) {
            context.error("The main component needs a name! Hint: Check component name available.");
        }
    }

    public void noticeParameterStatus(ComponentDefinition componentDefinition, String id, NoticeParameterValidationContext context) {
        if (componentDefinition == null) {
            return;
        }
        if (componentDefinition.getComponentStatus() != null && !componentDefinition.getComponentStatus().isEmpty()) {
            String msg = "[Component: " + id + "]: " + componentDefinition.getComponentStatus();
            ContextError error = new ContextError(Type.ERROR, msg);
            context.getMessages().add(error);
        }
    }

    public void validateCopyrights(ComponentDefinition componentDefinition, String id, NoticeParameterValidationContext context) {
        if (componentDefinition == null) {
            return;
        }
        for (String license : this.noticeUtils.getEffectiveLicenses(componentDefinition)) {
            ContextError error;
            String msg;
            TermsMetaData tmd = this.getTermsMetaData(license, context);
            if (tmd.getRequiresCopyright() != null) {
                if (tmd.getRequiresCopyright().booleanValue() && !componentDefinition.hasCopyrights()) {
                    if (componentDefinition.isMissingCopyrights() && !tmd.isMissingCopyrightNotAllowed()) continue;
                    if (tmd.isMissingCopyrightNotAllowed()) {
                        msg = "[Component: " + id + "]: " + license + " requires copyrights. Add Copyright. Hint: This license does not allow NO copyrights. Check for default copyright sentence in license.";
                        error = new ContextError(Type.ERROR, msg);
                        context.getMessages().add(error);
                        continue;
                    }
                    msg = "[Component: " + id + "]: " + license + " requires copyrights. Hint: Insert copyrights or set flag \"missingCopyrights: true\" in notice parameter";
                    error = new ContextError(Type.ERROR, msg);
                    context.getMessages().add(error);
                    continue;
                }
                if (tmd.getRequiresCopyright().booleanValue() || !componentDefinition.hasCopyrights()) continue;
                msg = "[Component: " + id + "]: " + license + " does not require copyrights, but there are copyrights present in the notice parameter. Hint: Check whether this is on purpose / Consider splitting this component to enable exact assignment of copyrights";
                error = new ContextError(Type.INFO, msg);
                context.getMessages().add(error);
                continue;
            }
            if (componentDefinition.hasCopyrights() || componentDefinition.isMissingCopyrights()) continue;
            msg = "[Component: " + id + "]: No information available whether " + license + " requires copyrights. Maybe missing copyrights.";
            error = new ContextError(Type.INFO, msg);
            context.getMessages().add(error);
        }
    }

    public void validateNote(ComponentDefinition componentDefinition, String id, NoticeParameterValidationContext context) {
        if (componentDefinition == null) {
            return;
        }
        for (String license : this.noticeUtils.getEffectiveLicenses(componentDefinition)) {
            ContextError error;
            CharSequence msg;
            TermsMetaData termsMetaData = this.getTermsMetaData(license, context);
            if (!componentDefinition.isNoteSet() && termsMetaData.isRequiresNote()) {
                if (termsMetaData.getNoteChecklist() != null && !termsMetaData.getNoteChecklist().isEmpty()) {
                    msg = new StringBuilder("[Component: " + id + "]: " + license + " requires a note! Please add all of the following information to the note:");
                    for (String todo : termsMetaData.getNoteChecklist()) {
                        ((StringBuilder)msg).append("\n - ").append(todo);
                    }
                    error = new ContextError(Type.WARNING, ((StringBuilder)msg).toString());
                    context.getMessages().add(error);
                } else {
                    msg = "[Component: " + id + "]: " + license + " requires a note! Hint: Add a note (no checklist available).";
                    error = new ContextError(Type.WARNING, (String)msg);
                    context.getMessages().add(error);
                }
            }
            if (!componentDefinition.isNoteSet() || !componentDefinition.getNote().isEmpty()) continue;
            msg = "[Component: " + id + "]: Empty note specified. Hint: Check whether note is required.";
            error = new ContextError(Type.WARNING, (String)msg);
            context.getMessages().add(error);
        }
    }

    private void validateVariables(ComponentDefinition componentDefinition, String id, NoticeParameterValidationContext context) {
        ContextError error;
        Object msg;
        TermsMetaData tmd;
        if (componentDefinition == null) {
            return;
        }
        int licensesWithVariables = 0;
        for (String effectiveLicense : this.noticeUtils.getEffectiveLicenses(componentDefinition)) {
            tmd = this.getTermsMetaData(effectiveLicense, context);
            if (tmd.getLicenseTemplate() == null || !tmd.getLicenseTemplate().contains("{{")) continue;
            if (componentDefinition.getVariables() == null) {
                String msg2 = "[Component: " + id + "]: Provide variable set for " + effectiveLicense + ".";
                ContextError error2 = new ContextError(Type.ERROR, msg2);
                context.getMessages().add(error2);
            }
            ++licensesWithVariables;
        }
        if (componentDefinition.getVariables() == null) {
            return;
        }
        if (licensesWithVariables == 0) {
            msg = "[Component: " + id + "]: None of the licenses in this component requires variables, but variables are specified. Hint: Check whether license is missing or variables are obsolete.";
            error = new ContextError(Type.WARNING, (String)msg);
            context.getMessages().add(error);
        } else if (licensesWithVariables == 1) {
            for (String effectiveLicense : this.noticeUtils.getEffectiveLicenses(componentDefinition)) {
                tmd = this.getTermsMetaData(effectiveLicense, context);
                if (tmd.getLicenseTemplate() == null || !tmd.getLicenseTemplate().contains("{{")) continue;
                String licenseTemplate = tmd.getLicenseTemplate();
                for (Map.Entry entry : componentDefinition.getVariables().entrySet()) {
                    String key = "{{" + (String)entry.getKey() + "}}";
                    if (licenseTemplate.contains(key)) {
                        licenseTemplate = licenseTemplate.replace(key, "");
                        continue;
                    }
                    String msg3 = "[Component: " + id + "]: Wrong variable specified. " + key + "is wrong.";
                    ContextError error3 = new ContextError(Type.ERROR, msg3);
                    context.getMessages().add(error3);
                }
                if (!licenseTemplate.matches(".*\\{\\{([^\\}]+)}}.*")) continue;
                String msg4 = "[Component: " + id + "]: There are still un-replaced variables in the notice Parameter";
                ContextError contextError = new ContextError(Type.ERROR, msg4);
                context.getMessages().add(contextError);
            }
        } else if (licensesWithVariables > 1) {
            msg = "[Component: " + id + "]: At least two of the licenses in this component require variables, but only one variable set is specified. Hint: Split into subcomponents and add variable set.";
            error = new ContextError(Type.ERROR, (String)msg);
            context.getMessages().add(error);
        }
        if (componentDefinition.getVariables().containsValue("")) {
            msg = "[Component: " + id + "]: At least one variable in component has empty content. Provide Variable content";
            error = new ContextError(Type.ERROR, (String)msg);
            context.getMessages().add(error);
        }
    }

    public void validateLicenses(ComponentDefinition componentDefinition, String id, NoticeParameterValidationContext context) {
        if (componentDefinition == null) {
            return;
        }
        for (String effectiveLicense : this.noticeUtils.getEffectiveLicenses(componentDefinition)) {
            if (!effectiveLicense.contains("undefined")) continue;
            String msg = "[Component: " + id + "]: " + effectiveLicense + " is not appropriate as effective license.";
            ContextError error = new ContextError(Type.WARNING, msg);
            context.getMessages().add(error);
        }
    }

    public TermsMetaData getTermsMetaData(String license, NoticeParameterValidationContext context) {
        TermsMetaData termsMetaData = this.normalizationMetaData.resolveTermsMetaData(license);
        if (termsMetaData == null) {
            String msg = "No terms metadata for " + license + "! Hint: Isolate and provide license text to be added to metadata.";
            ContextError error = new ContextError(Type.ERROR, msg);
            context.getMessages().add(error);
            return NoticeUtils.createDefaultTermsMetaData(license);
        }
        return termsMetaData;
    }

    public class ContextError {
        Type type;
        String message;

        public ContextError(Type type, String message) {
            this.type = type;
            this.message = message;
        }

        public void addError(NoticeParameterValidationContext context) {
            context.getMessages().add(this);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.message});
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof ContextError) {
                ContextError toCompare = (ContextError)o;
                if (!Objects.equals((Object)toCompare.type, (Object)this.type)) {
                    return false;
                }
                return Objects.equals(toCompare.message, this.message);
            }
            return false;
        }
    }

    public static enum Type {
        WARNING,
        ERROR,
        INFO;

    }
}

