/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.notice.engine.utils;

import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.metaeffekt.common.notice.model.ComponentDefinition;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.core.inventory.processor.report.PreFormattedEscapeUtils;
import org.metaeffekt.notice.engine.NoticeEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NoticeUtils.class);
    public static final String SEPARATOR_PLUS = " + ";
    public static final String SEPARATOR_COMMA = ", ";
    public static final PreFormattedEscapeUtils ESCAPE_UTILS = new PreFormattedEscapeUtils();
    public final NormalizationMetaData normalizationMetaData;

    public NoticeUtils(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
    }

    private TermsMetaData getTermsMetaDataNullable(String license) {
        return this.normalizationMetaData.resolveTermsMetaData(license);
    }

    private TermsMetaData getTermsMetaDataNonNull(String license) {
        TermsMetaData termsMetaData = this.normalizationMetaData.resolveTermsMetaData(license);
        if (termsMetaData == null) {
            return NoticeUtils.createDefaultTermsMetaData(license);
        }
        return termsMetaData;
    }

    public static TermsMetaData createDefaultTermsMetaData(String name) {
        TermsMetaData tmd = new TermsMetaData();
        tmd.setCanonicalName(name);
        tmd.setRequiresNote(true);
        tmd.setRequiresCopyright(Boolean.valueOf(false));
        tmd.setTemporaryLMD(true);
        return tmd;
    }

    public String enumerate(List<String> originalLicenseList, String conjunction, String article, String language) {
        if (originalLicenseList == null || originalLicenseList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < originalLicenseList.size(); ++i) {
            String license = originalLicenseList.get(i);
            license = license.contains(SEPARATOR_PLUS) ? this.enrichLicenseOption(license, article, language) : this.prependArticle(license, article, language);
            if (i > 0) {
                sb.append(SEPARATOR_COMMA);
            }
            if (i == originalLicenseList.size() - 1 && originalLicenseList.size() > 1) {
                sb.append(conjunction).append(" ");
            }
            sb.append(license);
        }
        return sb.toString();
    }

    private String enrichLicenseOption(String licenseOption, String article, String language) {
        String[] licenses = licenseOption.split(" \\+ ");
        StringBuilder internalSb = new StringBuilder();
        for (String license : licenses) {
            if (internalSb.length() > 0) {
                internalSb.append(" ").append(this.getTranslatedTerm("OR_" + language)).append(" ");
            }
            internalSb.append(this.prependArticle(license, article, language));
        }
        return this.getTranslatedTerm("EITHER_" + language) + " " + internalSb;
    }

    private String prependArticle(String license, String article, String language) {
        TermsMetaData termsMetaData = this.getTermsMetaDataNonNull(license);
        if (!termsMetaData.isArticleRequired() && language.equals("en_US")) {
            return license;
        }
        if (license.startsWith("Permission Terms") && language.equals("de_DE")) {
            return "von " + license;
        }
        return article + " " + license;
    }

    private String getTranslatedTerm(String term) {
        if (term.equals("OR_en_US")) {
            return "or";
        }
        if (term.equals("OR_de_DE")) {
            return "oder";
        }
        if (term.equals("EITHER_en_US")) {
            return "either";
        }
        if (term.equals("EITHER_de_DE")) {
            return "entweder";
        }
        return null;
    }

    public String enumerateX(List<String> list, String conjunction, String article, String language) {
        String s = this.enumerate(list, conjunction, article, language);
        s = StringUtils.capitalize((String)s);
        return s;
    }

    public List<String> getAssociatedLicenses(NoticeParameters noticeParameters) {
        HashSet<String> aggregated = new HashSet<String>(this.getAssociatedLicenses(noticeParameters.getComponent()));
        for (ComponentDefinition componentDefinition : noticeParameters.getSubcomponents()) {
            aggregated.addAll(this.getAssociatedLicenses(componentDefinition));
        }
        return aggregated.stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList());
    }

    public List<String> getEffectiveLicenses(NoticeParameters noticeParameters) {
        HashSet<String> aggregated = new HashSet<String>(this.getEffectiveLicenses(noticeParameters.getComponent()));
        for (ComponentDefinition componentDefinition : noticeParameters.getSubcomponents()) {
            aggregated.addAll(this.getEffectiveLicenses(componentDefinition));
        }
        return aggregated.stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList());
    }

    public boolean hasLicensingOption(NoticeParameters noticeParameters) {
        return !this.getAssociatedLicenses(noticeParameters).equals(this.getEffectiveLicenses(noticeParameters));
    }

    public List<ComponentDefinition> getComponentsWithLicenseOption(NoticeParameters noticeParameters) {
        ArrayList<ComponentDefinition> componentDefinitionList = new ArrayList<ComponentDefinition>();
        if (this.getOptionalLicenses(noticeParameters.getComponent())) {
            componentDefinitionList.add(noticeParameters.getComponent());
        }
        for (ComponentDefinition componentDefinition : noticeParameters.getSubcomponents()) {
            if (!this.getOptionalLicenses(componentDefinition)) continue;
            componentDefinitionList.add(componentDefinition);
        }
        return componentDefinitionList;
    }

    private boolean getOptionalLicenses(ComponentDefinition component) {
        return component.getEffectiveLicenses() != null;
    }

    private Collection<String> getAssociatedLicenses(ComponentDefinition component) {
        return component.getAssociatedLicenses();
    }

    public Collection<String> getEffectiveLicenses(ComponentDefinition component) {
        if (component.getEffectiveLicenses() == null || component.getEffectiveLicenses().isEmpty()) {
            return component.getAssociatedLicenses();
        }
        return component.getEffectiveLicenses();
    }

    public NoticeSummary evaluateMeta(NoticeParameters noticeParameters) throws Exception {
        List<String> effectiveLicense = this.getEffectiveLicenses(noticeParameters);
        NoticeSummary noticeSummary = new NoticeSummary();
        for (String license : effectiveLicense) {
            TermsMetaData termsMetaData = this.getTermsMetaDataNonNull(license);
            if (!termsMetaData.isRequiresSourceCodeProvision()) continue;
            noticeSummary.requiresSourceCodeProvision = true;
            noticeSummary.licensesRequiringSourceCodeProvisioning.add(license);
        }
        return noticeSummary;
    }

    public String getLicenseTemplateName(String license, NoticeEngine noticeEngine) {
        try {
            String template;
            String language = noticeEngine.getProjectContext().getLanguageMode().toString();
            TermsMetaData tmd = this.normalizationMetaData.resolveTermsMetaData(license);
            if (tmd != null) {
                license = tmd.getCanonicalName();
                if (tmd.getNoticeTemplateId() != null && noticeEngine.resourceExists(template = "notice-template/" + language + "/template-id/" + tmd.getNoticeTemplateId() + ".vm")) {
                    return template;
                }
            }
            template = "notice-template/" + language + "/license-templates/" + license + ".vm";
            if (tmd != null && tmd.getCanonicalNameHistory() != null) {
                for (String historicalCanonicalName : tmd.getCanonicalNameHistory()) {
                    template = "notice-template/" + language + "/license-templates/" + historicalCanonicalName + ".vm";
                    if (!noticeEngine.resourceExists(template)) continue;
                    break;
                }
            }
            if (noticeEngine.resourceExists(template)) {
                return template;
            }
            String representedLicenseName = this.representedLicenseName(license);
            template = "notice-template/" + language + "/license-templates/" + representedLicenseName + ".vm";
            if (noticeEngine.resourceExists(template)) {
                return template;
            }
            tmd = this.getTermsMetaDataNullable(representedLicenseName);
            if (tmd != null && tmd.getNoticeTemplateId() != null && noticeEngine.resourceExists(template = "notice-template/" + language + "/template-id/" + tmd.getNoticeTemplateId() + ".vm")) {
                return template;
            }
            Map historicalCanonicalNameMap = this.normalizationMetaData.getHistoricalCanonicalNameMap();
            if (historicalCanonicalNameMap.containsValue(license)) {
                for (String key : historicalCanonicalNameMap.keySet()) {
                    String noticeTemplateID;
                    String value = (String)historicalCanonicalNameMap.get(key);
                    if (value.equals(license)) {
                        noticeTemplateID = this.getTermsMetaDataNonNull(key).getNoticeTemplateId();
                        if (noticeTemplateID != null && noticeEngine.resourceExists(template = "notice-template/" + language + "/template-id/" + noticeTemplateID + ".vm")) {
                            return template;
                        }
                        template = "notice-template/" + language + "/license-templates/" + key + ".vm";
                        if (noticeEngine.resourceExists(template)) {
                            return template;
                        }
                    }
                    if (!value.equals(representedLicenseName)) continue;
                    noticeTemplateID = this.getTermsMetaDataNonNull(key).getNoticeTemplateId();
                    if (noticeTemplateID != null && noticeEngine.resourceExists(template = "notice-template/" + language + "/template-id/" + noticeTemplateID + ".vm")) {
                        return template;
                    }
                    template = "notice-template/" + language + "/license-templates/" + key + ".vm";
                    if (!noticeEngine.resourceExists(template)) continue;
                    return template;
                }
            }
            if (this.generateTemplatePossible(license)) {
                return "notice-template/" + language + "/license-templates/Generate Template.vm";
            }
            return "notice-template/" + language + "/license-templates/Default Template.vm";
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private boolean generateTemplatePossible(String license) {
        TermsMetaData tmd = this.getTermsMetaDataNullable(license);
        if (tmd == null) {
            return false;
        }
        if (tmd.getType() != null && (tmd.isException() || tmd.isExpression() || tmd.isMarker())) {
            return false;
        }
        if (license.contains("(or any later version)")) {
            return false;
        }
        if (tmd.isUnspecific()) {
            return false;
        }
        return tmd.getRequiresCopyright() != null && tmd.getRequiresLicenseText() != null;
    }

    public List<String> processingCopyrights(List<String> inputCopyrights) {
        ArrayList<String> copyrights = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>(inputCopyrights);
        copyrights.addAll(hashSet);
        copyrights.sort(Comparator.naturalOrder());
        return copyrights;
    }

    public String getDisplayName(String license) {
        TermsMetaData termsMetaData = this.getTermsMetaDataNonNull(license);
        if (termsMetaData.getDisplayName() != null) {
            return termsMetaData.getDisplayName();
        }
        return license;
    }

    public List<String> getDisplayNames(List<String> licenses) {
        ArrayList<String> displayNames = new ArrayList<String>();
        for (String license : licenses) {
            displayNames.add(this.getDisplayName(license));
        }
        return displayNames;
    }

    public String representedLicenseName(String license) {
        TermsMetaData representedTMD;
        TermsMetaData termsMetaData = this.getTermsMetaDataNonNull(license);
        String representedLicenseName = termsMetaData.getRepresentedAs() != null ? ((representedTMD = this.getTermsMetaDataNonNull(termsMetaData.getRepresentedAs())).getBaseTerms() != null ? representedTMD.getBaseTerms() : termsMetaData.getRepresentedAs()) : (termsMetaData.getBaseTerms() != null ? termsMetaData.getBaseTerms() : license);
        return representedLicenseName;
    }

    public String getLicenseTemplate(String effectiveLicense, ComponentDefinition componentDefinition) throws Exception {
        TermsMetaData termsMetaData = this.getTermsMetaDataNonNull(effectiveLicense);
        String licenseTemplate = termsMetaData.getLicenseTemplate();
        if (licenseTemplate == null && termsMetaData.getRepresentedAs() != null) {
            termsMetaData = this.getTermsMetaDataNonNull(termsMetaData.getRepresentedAs());
            licenseTemplate = termsMetaData.getLicenseTemplate();
        }
        if (licenseTemplate == null) {
            return "";
        }
        return this.replacePlaceHolders(licenseTemplate, componentDefinition);
    }

    private String replacePlaceHolders(String licenseTemplate, ComponentDefinition componentDefinition) throws Exception {
        if (!licenseTemplate.contains("{{")) {
            return licenseTemplate;
        }
        if (componentDefinition.getVariables() != null) {
            for (Map.Entry entry : componentDefinition.getVariables().entrySet()) {
                String key = "{{" + (String)entry.getKey() + "}}";
                if (licenseTemplate.contains(key)) {
                    licenseTemplate = licenseTemplate.replace(key, ESCAPE_UTILS.xml((String)entry.getValue()));
                    continue;
                }
                LOG.warn("The variable {} can't be found in the license template.", entry.getKey());
            }
        }
        if (licenseTemplate.matches(".*\\{\\{([^\\}]+)}}.*")) {
            this.throwException("There are still un-replaced variables in the notice Parameter:\n======\nidentified license: " + componentDefinition.getAssociatedLicenses() + "\nlicense template:\n>>>>>>\n" + licenseTemplate.replace("{{", "{*******{").replace("}}", "}******}") + "\n<<<<<<\n");
        }
        return licenseTemplate;
    }

    public boolean nameExisting(ComponentDefinition componentDefinition) {
        return componentDefinition.getName() != null;
    }

    public boolean componentSeparationRequired(NoticeParameters noticeParameters) {
        boolean componentSeparationRequired = false;
        ArrayList effectiveLicenses = new ArrayList();
        for (ComponentDefinition subcomponent : noticeParameters.getSubcomponents()) {
            if (this.nameExisting(subcomponent)) {
                componentSeparationRequired = true;
            }
            effectiveLicenses.addAll(subcomponent.getAssociatedLicenses());
        }
        for (String license : this.getEffectiveLicenses(noticeParameters.getComponent())) {
            if (!effectiveLicenses.contains(license)) continue;
            componentSeparationRequired = true;
        }
        return componentSeparationRequired;
    }

    public List<ComponentDefinition> getSelectedComponents(List<ComponentDefinition> subcomponents, boolean namedComponents) {
        ArrayList<ComponentDefinition> selectedComponents = new ArrayList<ComponentDefinition>();
        for (ComponentDefinition subcomponent : subcomponents) {
            if (this.nameExisting(subcomponent) && namedComponents) {
                selectedComponents.add(subcomponent);
                continue;
            }
            if (this.nameExisting(subcomponent) || namedComponents) continue;
            selectedComponents.add(subcomponent);
        }
        return selectedComponents;
    }

    public List<String> getEffectiveLicensesUnnamedComponents(List<ComponentDefinition> subcomponents) {
        List<ComponentDefinition> unnamedComponents = this.getSelectedComponents(subcomponents, false);
        ArrayList<String> effectiveLicenses = new ArrayList<String>();
        for (ComponentDefinition unnamedComponent : unnamedComponents) {
            effectiveLicenses.addAll(this.getEffectiveLicenses(unnamedComponent));
        }
        HashSet set = new HashSet(effectiveLicenses);
        effectiveLicenses.clear();
        effectiveLicenses.addAll(set);
        return effectiveLicenses;
    }

    private void throwException(String exception) {
        throw new IllegalStateException(exception);
    }

    public boolean requiresCopyright(String license) {
        TermsMetaData termsMetaData = this.getTermsMetaDataNullable(license);
        if (termsMetaData != null) {
            return termsMetaData.getRequiresCopyright();
        }
        return false;
    }

    public boolean requiresLicenseText(String license) {
        return this.getTermsMetaDataNonNull(license).getRequiresLicenseText();
    }

    public String getRightLicenseTemplate(String license) {
        TermsMetaData tmd = this.getTermsMetaDataNullable(license);
        if (tmd.getLicenseTemplate() != null) {
            return license;
        }
        return this.representedLicenseName(license);
    }

    public NormalizationMetaData getNormalizationMetaData() {
        return this.normalizationMetaData;
    }

    public static class NoticeSummary {
        boolean requiresSourceCodeProvision = false;
        boolean requiresLicenseAndNoticeProvision = false;
        List<String> licensesRequiringSourceCodeProvisioning = new ArrayList<String>();
        List<String> licensesRequiringLicenseAndNoticeProvisioning = new ArrayList<String>();

        public List<String> getLicensesRequiringLicenseAndNoticeProvisioning() {
            return this.licensesRequiringLicenseAndNoticeProvisioning;
        }

        public List<String> getLicensesRequiringSourceCodeProvisioning() {
            return this.licensesRequiringSourceCodeProvisioning;
        }

        public boolean isRequiresLicenseAndNoticeProvision() {
            return this.requiresLicenseAndNoticeProvision;
        }

        public boolean isRequiresSourceCodeProvision() {
            return this.requiresSourceCodeProvision;
        }

        public String toString() {
            return "NoticeSummary{requiresSourceCodeProvision=" + this.requiresSourceCodeProvision + ", requiresLicenseAndNoticeProvision=" + this.requiresLicenseAndNoticeProvision + ", licensesRequiringSourceCodeProvisioning=" + this.licensesRequiringSourceCodeProvisioning + ", licensesRequiringLicenseAndNoticeProvisioning=" + this.licensesRequiringLicenseAndNoticeProvisioning + '}';
        }
    }
}

