/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.scancode;

import com.metaeffekt.artifact.analysis.scancode.ScanCodeBackend;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeService;
import com.metaeffekt.artifact.analysis.scancode.ScanRequest;
import com.metaeffekt.artifact.analysis.scancode.ScanRequestResponse;
import com.metaeffekt.artifact.analysis.scancode.ScanStatus;
import com.metaeffekt.artifact.analysis.scancode.UUIDNotFoundException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;

public class ScanCodeDefaultBackend
implements ScanCodeBackend {
    private final ScanCodeService service;
    private final Converter<ResponseBody, ErrorBody> errorConverter;

    public ScanCodeDefaultBackend(ScanCodeService service, Converter<ResponseBody, ErrorBody> errorConverter) {
        this.service = service;
        this.errorConverter = errorConverter;
    }

    @Override
    public ScanRequestResponse scan(String scanPath, String outputFile) throws IOException {
        Call<ScanRequestResponse> responseCall = this.service.requestScan(new ScanRequest(scanPath, outputFile));
        Response response = responseCall.execute();
        if (response.isSuccessful()) {
            return (ScanRequestResponse)response.body();
        }
        ErrorBody error = (ErrorBody)this.errorConverter.convert((Object)response.errorBody());
        throw new FileNotFoundException(error.detail);
    }

    @Override
    public boolean isRunning(UUID uuid) throws IOException, UUIDNotFoundException {
        Call<ScanStatus> isRunning = this.service.isRunning(uuid);
        Response response = isRunning.execute();
        if (!response.isSuccessful()) {
            ErrorBody error = (ErrorBody)this.errorConverter.convert((Object)response.errorBody());
            throw new UUIDNotFoundException(error.detail);
        }
        return response.code() == 200;
    }

    public static class ErrorBody {
        String detail;
    }
}

