/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.scancode;

import com.metaeffekt.artifact.analysis.scancode.ScanCodeDefaultBackend;
import com.metaeffekt.artifact.analysis.scancode.ScanRequest;
import com.metaeffekt.artifact.analysis.scancode.ScanRequestResponse;
import com.metaeffekt.artifact.analysis.scancode.ScanStatus;
import java.lang.annotation.Annotation;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface ScanCodeService {
    public static ScanCodeService create(String baseUrl) {
        HttpUrl url = HttpUrl.get((String)baseUrl);
        return ScanCodeService.create(url);
    }

    public static ScanCodeService create(HttpUrl url) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        return (ScanCodeService)retrofit.create(ScanCodeService.class);
    }

    public static Converter<ResponseBody, ScanCodeDefaultBackend.ErrorBody> getErrorConverter(String baseUrl) {
        HttpUrl url = HttpUrl.get((String)baseUrl);
        return ScanCodeService.getErrorConverter(url);
    }

    public static Converter<ResponseBody, ScanCodeDefaultBackend.ErrorBody> getErrorConverter(HttpUrl url) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        return retrofit.responseBodyConverter(ScanCodeDefaultBackend.ErrorBody.class, new Annotation[0]);
    }

    @POST(value="scan/")
    public Call<ScanRequestResponse> requestScan(@Body ScanRequest var1);

    @GET(value="scan/{id}")
    public Call<ScanStatus> isRunning(@Path(value="id") UUID var1);
}

