/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.scancode;

import com.metaeffekt.artifact.analysis.scancode.ScanCodeHttpClient;
import com.metaeffekt.artifact.analysis.scancode.ScanRequestResponse;
import com.metaeffekt.artifact.analysis.scancode.ThrowingStrategy;
import com.metaeffekt.artifact.analysis.scancode.UUIDNotFoundException;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForeverStrategy
implements ThrowingStrategy<ScanCodeHttpClient, ScanRequestResponse, Boolean, IOException> {
    private static final Logger LOG = LoggerFactory.getLogger(WaitForeverStrategy.class);
    private final int timeout;

    public WaitForeverStrategy() {
        this.timeout = 60;
    }

    public WaitForeverStrategy(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public Boolean apply(ScanCodeHttpClient client, ScanRequestResponse response) throws IOException {
        File awaitedFile = new File(response.getOutput_file());
        boolean fileFound = false;
        while (!fileFound) {
            fileFound = FileUtils.waitFor((File)awaitedFile, (int)this.timeout);
            if (fileFound) continue;
            WaitForeverStrategy.isScanRunning(client, response);
        }
        return true;
    }

    private static boolean isScanRunning(ScanCodeHttpClient client, ScanRequestResponse response) throws IOException {
        try {
            return client.isScanRunning(response.getUuid());
        }
        catch (SocketTimeoutException e) {
            LOG.warn("Scancode Service did not respond for UUID {} by timeout. Further waiting for output file {}.", (Object)response.getUuid(), (Object)response.getOutput_file());
        }
        catch (UUIDNotFoundException e) {
            LOG.warn("UUID {} not found. Further waiting for output file {}.", (Object)response.getUuid(), (Object)response.getOutput_file());
        }
        return false;
    }
}

