/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.scancode;

import com.metaeffekt.artifact.analysis.scancode.ScanCodeHttpClient;
import com.metaeffekt.artifact.analysis.scancode.ScanRequestResponse;
import com.metaeffekt.artifact.analysis.scancode.ThrowingStrategy;
import com.metaeffekt.artifact.analysis.scancode.UUIDNotFoundException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class AwaitConclusionStrategy
implements ThrowingStrategy<ScanCodeHttpClient, ScanRequestResponse, Boolean, IOException> {
    private final int timeout;

    public AwaitConclusionStrategy() {
        this.timeout = 10;
    }

    public AwaitConclusionStrategy(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public Boolean apply(ScanCodeHttpClient client, ScanRequestResponse response) throws IOException {
        File outputFile = new File(response.getOutput_file());
        while (AwaitConclusionStrategy.isScanRunning(client, response)) {
            if (!FileUtils.waitFor((File)outputFile, (int)this.timeout)) continue;
            return true;
        }
        return FileUtils.waitFor((File)outputFile, (int)this.timeout);
    }

    private static boolean isScanRunning(ScanCodeHttpClient client, ScanRequestResponse response) throws IOException {
        try {
            return client.isScanRunning(response.getUuid());
        }
        catch (UUIDNotFoundException e) {
            return false;
        }
    }
}

