/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.scancode;

import com.metaeffekt.artifact.analysis.scancode.ScanCodeHttpClient;
import com.metaeffekt.artifact.analysis.scancode.ScanRequestResponse;
import com.metaeffekt.artifact.analysis.scancode.ThrowingStrategy;
import com.metaeffekt.artifact.analysis.scancode.UUIDNotFoundException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class CumulativeTimeoutStrategy
implements ThrowingStrategy<ScanCodeHttpClient, ScanRequestResponse, Boolean, IOException> {
    private final int timeout;

    public CumulativeTimeoutStrategy() {
        this.timeout = 60;
    }

    public CumulativeTimeoutStrategy(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public Boolean apply(ScanCodeHttpClient client, ScanRequestResponse response) throws IOException {
        File awaitedFile = new File(response.getOutput_file());
        boolean fileFound = false;
        for (int i = 0; i < 5; ++i) {
            fileFound = FileUtils.waitFor((File)awaitedFile, (int)this.timeout);
            if (!CumulativeTimeoutStrategy.isScanRunning(client, response)) {
                fileFound = FileUtils.waitFor((File)awaitedFile, (int)this.timeout);
            }
            if (fileFound) break;
        }
        return fileFound;
    }

    private static boolean isScanRunning(ScanCodeHttpClient client, ScanRequestResponse response) throws IOException {
        try {
            return client.isScanRunning(response.getUuid());
        }
        catch (UUIDNotFoundException e) {
            return false;
        }
    }
}

